/* ESTADO DE LOS PEDIDOS
a = aperturado/abierto/activo/
b = preparacion
c = en camino
d = despachado/entregado/cerrado
z = anulado
*/ 

var moneda = $("#moneda").val();
$(function() {
    moment.locale('es');
    mesa_list(1);
    tiempo_mesa();
    //setInterval(tiempo_mesa, 1000);
    tiempo_pedido();
    //setInterval(tiempo_pedido, 1000);
    tiempo_preparacion();
    //setInterval(tiempo_preparacion, 1000);
    countNuevoPedidoDelivery();
    //setInterval(countNuevoPedidoDelivery, 10000);
    alert_pedidos_programados();
    //setInterval(alert_pedidos_programados, 50000);
    validarApertura();
    
    
    const pusher = new Pusher('01c14cdca26db19318e0', {
        cluster: 'us2',
        forceTLS: true
      });

    const channel = pusher.subscribe('bolichera-channel');

    channel.bind('new-notification', function(data) {
        console.log('Notificación recibida:', data);
        mesa_list(1);
        
      });


    $('.scroll_list_items_facturar').slimscroll({
        height: '100%'
    });
    var scroll_list_items_facturar = function () {
        var topOffset = 400;
        var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
        height = height - topOffset;
        $(".scroll_list_items_facturar").css("height", (height) + "px");
    };

    $(window).ready(scroll_list_items_facturar);
    $(window).on("resize", scroll_list_items_facturar);

    var parametro = getUrlParameter('cod');
    if(parametro !== undefined){
        if(getUrlParameter('tip') == 3){
            $('#codtipoped').val(3);
            listarPedidosDetalle(3,parametro,0);
            activaTab('tabp-3');
            $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc3');
            if(getUrlParameter('est') == 'a'){
                $('#codpestdelivery').val(1);
                activaTab('delivery01');
                delivery_list_a();
                editar_pedido(parametro);
            } else if (getUrlParameter('est') == 'b'){
                activaTab('delivery02');
                delivery_list_b();
            } else if (getUrlParameter('est') == 'c'){
                activaTab('delivery03');
                delivery_list_c();
            } else if (getUrlParameter('est') == 'd'){
                activaTab('delivery04');
                delivery_list_d();
            }
            $('.display-estado-mesa').css('display','none');
            $('.cont01-1').css('display','none');
            $('.cont01-2').css('display','block');
        } else if(getUrlParameter('tip') == 2){
            activaTab('tabp-2');
            if(getUrlParameter('est') == 'a'){
                $('#codtipoped').val(2);
                activaTab('mostrador01');
                mostrador_list_a();
                //listarPedidosDetalle(2,parametro,0);
            }
            $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc2');
            $('.display-estado-mesa').css('display','none');
            $('.cont01-1').css('display','none');
            $('.cont01-2').css('display','block');
        }        
    }
    $('#form-nuevo-pedido').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        if($('#codtipoped').val() == 3 && $('#cliente_id').val() == ''){
            Swal.fire({   
                title:'Advertencia',   
                text: 'Ingrese un cliente al pedido',
                icon: "warning", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            return false;
        } else {
            e.preventDefault();
            var $form = $(e.target);
            var fv = $form.data('formValidation');
            fv.defaultSubmit();
        }
    });
    $('#form-cambiar-mesa').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        fv.defaultSubmit();
    });

    $(".opc-01").click(function() {
        $("#pago_efe").val($('.totalPedido').val());
        calculo_efectivo();
    });

    $('input[name="tipo_doc"]').on('change', function(){
        value = $('input:radio[name="tipo_doc"]:checked').val();
        $('#cliente_tipo').val(value);
        $('#tipo_cliente').val(value);
        $('#id_cliente').val('');
        // console.log(value)
        if(value == 3 || value == 1){
            $('#cliente_id').val(1);
            $('#buscar_cliente').val('DNI: 00000000 | PUBLICO EN GENERAL');
        }else{
            $('#cliente_id').val('');
            $('#buscar_cliente').val('');
        }
        $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
            +'onclick="nuevoClienteVista();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"'
            +'data-placement="top">'
                +'<span class="input-group-text bg-header">'
                    +'<small><i class="fas fa-user-plus"></i></small>'
               +'</span>'
            +'</a>');
    });

    $('#form-mover-pedidos').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        fv.defaultSubmit();
    });

    $('#form-editar-pedido')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    
    var id_repartidor = ($('#id_repartidor_edit').val() == null) ? '1' : $('#id_repartidor_edit').val();

    id_pedido = $('#id_pedido').val();
    hora_entrega = $('#hora_entrega_edit').val();
    id_repartidor = id_repartidor;
    amortizacion = $('#amortizacion').val();
    tipo_pago = $('#id_tipo_pago').val();
    paga_con = $('#paga_con').val();
    comision_delivery = $('#comision_delivery').val();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/pedido_crud',
        data: {
            id_pedido: id_pedido,
            id_repartidor: id_repartidor,
            hora_entrega: hora_entrega,
            amortizacion: amortizacion,
            tipo_pago: tipo_pago,
            paga_con: paga_con,
            comision_delivery: comision_delivery
        },
        success: function (cod) {
            $('#modal-editar-pedido').modal('hide');
            Swal.fire({   
                title:'Proceso Terminado',   
                text: 'Datos actualizados correctamente',
                icon: "success", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            delivery_list_a();
            delivery_list_b();
            listarPedidosDetalle(3,$('#id_pedido').val(),0);          
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }    
    });
        return false;
    });

    $('#btnDividirCuenta').on('click', function(event) {
        event.preventDefault();
        var id_pedido = $(this).data('id-pedido'); 
        var id_mesa = $(this).data('id-mesa');     
        
    });
    
    // Función para el botón "Cobrar"
    $('#btnCobrar').on('click', function(event) {
        event.preventDefault();
        var id_pedido = $(this).data('id-pedido'); 
        var id_mesa = $(this).data('id-mesa'); 
        
    });


    $('.venta_por_consumo').on('click', function(event){
        if( $(this).is(':checked') ) {
            $('#venta_por_consumo').val('1');
            $('.lista-producto-facturar').hide();
            $('.lista-venta-por-consumo').show();
            $('#venta_por_consumo_concepto').focus();
            $('#venta_por_consumo_concepto').select();
        } else {
            $('#venta_por_consumo').val('0');
            $('.lista-producto-facturar').show();
            $('.lista-venta-por-consumo').hide();
        }
    });

    $('#tipo_pago').change( function() { 

        var x = document.getElementById("tipo_pago").selectedIndex;
        value = document.getElementById("tipo_pago").options[x].label;

        
        if(value == 1){
            limpiar_pagos_a();
            $('.mensaje-pago').hide();
            $('.display-pago-efectivo').show();
            $('.display-pago-tarjeta').hide();
            $('.display-pago-default').show();
            $('.display-pago-rapido-efectivo').show();
            $('.display-codigo-operacion').hide();
            $("#pago_efe").val(formatNumber($('.totalPedido').val()));
            $('.opc-01').text(formatNumber($('.totalPedido').val()));


        } else if(value == 3){
            limpiar_pagos_a();
            $('.mensaje-pago').hide();
            $('.display-pago-efectivo').show();
            $('.display-pago-tarjeta').show();
            $('.display-pago-default').show();
            $('.display-pago-rapido-efectivo').show();
            $('.display-codigo-operacion').show();
        } else if(value == 4){
            limpiar_pagos_a();
            $('.mensaje-pago').show();
            //$('.mensaje-pago-text').text(' Esta venta ha sido pagado con Culqi');
            $('.display-pago-efectivo').hide();
            $('.display-pago-tarjeta').hide();
            $('.display-pago-default').hide();
            $('.display-pago-rapido-efectivo').hide();
            $('.display-codigo-operacion').show();
        } else if(value == 2 || value >= 5){
            limpiar_pagos_a();
            $('.mensaje-pago').hide();
            //$('.mensaje-pago-text').text(' Ingrese codigo de transferencia');
            $('.display-pago-efectivo').hide();
            $('.display-pago-tarjeta').hide();
            $('.display-pago-default').hide();
            $('.display-pago-rapido-efectivo').hide();
            $('.display-codigo-operacion').show();
        }
        calculo_total();
    });

    $("#buscar_cliente").autocomplete({
        delay: 1,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                url: $('#url').val() + 'venta/buscar_cliente',
                type: "post",
                dataType: "json",
                data: {
                    cadena: request.term,
                    tipo_cliente: $('#cliente_tipo').val()
                },
                success: function (data) {
                    console.log(data);
                    
                    // Si no hay data, devolvemos un arreglo vacío.
                    if (!data) {
                        response([]);
                        return;
                    }
                    
                    // Si data no es un arreglo, lo envolvemos en uno.
                    if (!Array.isArray(data)) {
                        data = [data];
                    }
                    
                    // Mapear los items. Se valida la existencia de propiedades y se normaliza el nombre.
                    var items = $.map(data, function (item) {
                        if (!item) return; // Evita errores si item es null
    
                        // Determina el prefijo según la existencia y valor de 'ruc' o el tipo de cliente.
                        // Puedes ajustar la lógica si la validación depende de otras propiedades.
                        var tipo_cli = (typeof item.ruc !== 'undefined' && item.ruc) ? $("#tribAcr").val() :  $("#diAcr").val();
                        
                        // Normalizamos el nombre: Si 'nombre' no existe, se intenta 'nombres', luego 'razonSocial'
                        var nombre = item.nombre || item.nombres || item.razonSocial || '';
    
                        return {
                            id: item.id_cliente || '',
                            dni: item.dni || '',
                            ruc: item.ruc || '',
                            tipo: item.tipo_cliente || '',
                            nombres: nombre,
                            fecha_n: item.fecha_nac || '',
                            label: tipo_cli + ': ' + (item.dni || '') + (item.ruc || '') + ' | ' + nombre,
                            value: tipo_cli + ': ' + (item.dni || '') + (item.ruc || '') + ' | ' + nombre
                        };
                    });
    
                    response(items);
                }
            });
        },
        select: function (e, ui) {
            $("#cliente_id").val(ui.item.id);
            $(this).blur();
            $("#btn-submit-facturar").removeAttr('disabled').removeClass('disabled');
            $('.opcion-cliente').html(
                '<a class="input-group-prepend" href="javascript:void(0)" ' +
                'onclick="editar_cliente(' + ui.item.id + ');" data-original-title="Editar cliente" data-toggle="tooltip" ' +
                'data-placement="top">' +
                '<span class="input-group-text bg-header"><small><i class="fas fa-user text-info"></i></small></span>' +
                '</a>'
            );
        }
    });
    $("#buscar_cliente").autocomplete("option", "appendTo", ".form-facturar");

    $('#form-facturar').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        var current_invoices = parseInt($("#current_invoices").val());
        var limits_invoices  = parseInt($("#limits_invoices").val());

        if ($("#cliente_id").val() == ''){
            Swal.fire({   
                title:'Advertencia',   
                text: 'Ingrese un cliente para el comprobante de pago',
                icon: "warning", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });

        }else if ($('#descuento_tipo_hidden').val() != '1' && ($('#tipo_pago').val() == '1' && Number($('.totalPedido').val()) > Number($('#pago_efe').val()))    ){
                Swal.fire({   
                    title:'Advertencia',   
                    text: 'Ingrese un monto mayor o igual al total',
                    icon: "warning", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });

        }else{

            // if ( (current_invoices >= limits_invoices)  && $("input[name=tipo_doc]:checked").val() !== '3'  && $("#locked_invoices").val() == '1'   ){ 
            if ( (current_invoices >= limits_invoices)  &&  $("#locked_invoices").val() == '1'   ){ 
                // console.log(current_invoices+" >= "+limits_invoices);
                Swal.fire({   
                    title:'Alcanzó el límite',   
                    text: 'Alcanzó el límite permitido para la emisión de comprobantes',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });

            }else {

                if ((current_invoices >= limits_invoices) && $("input[name=tipo_doc]:checked").val() !== '3'){

                    $.toast({
                        text: 'Alcanzó el límite permitido para la emisión de comprobantes',
                        position: 'top-right',
                        loaderBg:'#696969',
                        icon: 'error',
                        hideAfter: 3000, 
                        stack: 20,
                        allowToastClose: false,
                    });

                }
                var form = $(this);
                var venta = {
                    tipo_pedido: 0,
                    tipo_entrega: 0,
                    dividir_cuenta: 0,
                    id_pedido: 0,
                    cliente_id: 0,  
                    tipo_doc: 0,
                    tipo_pago: 0,
                    pago_efe: 0,
                    pago_tar: 0,
                    pago_yape: 0,
                    pago_plin: 0,
                    pago_tran: 0,
                    ibcper: 0,
                    descuento_tipo: 0,
                    descuento_personal: 0,
                    descuento_monto: 0,
                    descuento_motivo: 0,
                    comision_tarjeta: 0,
                    comision_delivery: 0,
                    codigo_operacion: 0,
                    venta_por_consumo: 0,
                    venta_por_consumo_concepto: 0,
                    observacion: 0,
                    total: 0,
                    idProd: [],
                    cantProd: [],
                    precProd: []
                }

                var tipo_descuento = ($('#descuento_tipo_hidden').val() == '') ? '2' : $('#descuento_tipo_hidden').val();

                venta.tipo_pedido = $('#codtipoped').val();
                venta.tipo_entrega = $('#codtipopedentrega').val();
                venta.dividir_cuenta = $('#dividir_cuenta').val();
                venta.id_pedido = $('#id_pedido').val();
                venta.cliente_id = $('#cliente_id').val();
                venta.tipo_doc = $('input:radio[name="tipo_doc"]:checked').val();
                venta.tipo_pago = $('#tipo_pago').val();
                venta.pago_efe = $('#pago_efe').val().replace(/,/g, "");
                venta.pago_tar = $('#pago_tar').val();
                venta.pago_yape = $('#pago_yape').val();
                venta.pago_plin = $('#pago_plin').val();
                venta.pago_tran = $('#pago_tran').val();
                venta.icbper = parseFloat($("#monto_icbper").val());
                venta.descuento_tipo = tipo_descuento;
                venta.descuento_personal = $('#descuento_personal_hidden').val();
                venta.descuento_monto = $('#descuento_monto_hidden').val();
                venta.descuento_motivo = $('#descuento_motivo_hidden').val();
                venta.comision_tarjeta = $('#comision_tarjeta').val();
                venta.comision_delivery = $('#comision_delivery').val();
                venta.codigo_operacion = $('#codigo_operacion').val();
                venta.venta_por_consumo = $("input[name='venta_por_consumo']").val();
                venta.venta_por_consumo_concepto = $('#venta_por_consumo_concepto').val();
                venta.observacion = $('#observacion').val();
                venta.total = $('#total_venta').val();
                venta.idProd = $("input[name='idProd[]']").map(function(){return $(this).val();}).get();
                venta.cantProd = $("input[name='cantProd[]']").map(function(){return $(this).val();}).get();
                venta.precProd = $("input[name='precProd[]']").map(function(){return $(this).val();}).get();

                var cod_ped = $('#id_pedido').val();
            
                var cod_ven = 0;

                let total=0,
                numeros = venta.cantProd;
                numeros.forEach(function(a){total += parseInt(a);});

                if (total==0) {
                    swal.close();
                        Swal.fire({   
                            title:'Advertencia',   
                            html: 'Seleccione un producto,<br>para poder cobrar',
                            icon: "warning", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                    total=0
                    return false
                }
                value = $('input:radio[name="tipo_doc"]:checked').val();
                if (value == undefined || value == "undefined") {
                    Swal.fire({
                        title: 'Seleccione tipo de documento',
                        icon: 'error',
                        showCancelButton: false,
                        showConfirmButton: true,
                    });
                    return false;
                }

                html_confirm = '<h4 class="m-t-20 font-bold">Registrando venta</h4></div>'
                            +'<div class="p-0">Espere un momento por favor...</div>';

                        Swal.fire({    
                            html: html_confirm,
                            timer: 100000,
                            allowOutsideClick: false,
                            allowEscapeKey : false,
                            showCancelButton: false,
                            showConfirmButton: false,
                            closeOnConfirm: false,
                            closeOnCancel: false,
                            onBeforeOpen: () => {
                                Swal.showLoading ()
                            }
                        });
						
						

                        $('.swal2-actions').addClass('p-b-20');

                        $.ajax({
                            type: 'POST',
                            url: $('#url').val()+'venta/RegistrarVenta',
                            data: venta,
                            success: function (dato) {
                                if(dato == '"error"'){
                                    var html_footer = $("#url").val()+'venta/orden/'+cod_ped;
                                    Swal.fire({   
                                        title:'Error',   
                                        text: 'Falta agregar productos',
                                        icon: "error", 
                                        footer: '<div><a class="btn btn-orange" href="'+html_footer+'" target="_self">Aceptar <i class="fas fa-arrow-right"></i></a></div>',
                                        allowOutsideClick: false,
                                        showCancelButton: false,
                                        showConfirmButton: false,
                                        closeOnConfirm: false,
                                        closeOnCancel: false
                                    }, function() {
                                        return false
                                    });                                  

                                }else{ 
                                    cod_ven = dato.replace(/['"]+/g, '');
                                    var urlticketreparto = $("#url").val()+'venta/impresion_reparto/'+cod_ven;
                                    // si es que esta activo el ver pdf
                                    if ($('#verpdf').val()==1) {
                                        var Urlpdfiframe = '<div class="col-6 col-md-6 hidden-md-down"><iframe src="'+$("#url").val()+'informe/venta_all_imp/'+cod_ven+'#toolbar=0" style="border:none;width: 100%;height: 100%;" /></div>';
                                        var withmodal = 800;
                                        var cantcolumn = 6;
                                    }else{var Urlpdfiframe = ''; var withmodal = 400;var cantcolumn = 12;}

                                    // var Urlpdfiframe = $("#url").val()+'informe/venta_all_imp/'+cod_ven; 
                                    if(1 == $('#dividir_cuenta').val()){
                                        var html_footer = $("#url").val()+'venta';
                                        //return true;
                                    } else if (2 == $('#dividir_cuenta').val()){
                                        var html_footer = $("#url").val()+'venta/orden/'+cod_ped;
                                        //return true; 
                                    }

                                    if($('#print_cpe').val() == 1){
                                        // imprimir directo  
                                        var linkpdf     = '<a href="'+$("#url").val()+'informe/venta_all_imp_/'+cod_ven+'" target="_blank" class="link"><i class="mdi mdi-receipt text-muted"></i></a>';
                                        var linkpdff    = '<a class="link" href="'+$("#url").val()+'informe/venta_all_imp_/'+cod_ven+'" target="_blank"><small>Imprimir comprobante</small></a>';
                                        var linkrep     = '<a class="link" href="'+$("#url").val()+'venta/impresion_reparto/'+cod_ven+'" target="_blank"><i class="fas fa-print text-muted"></i></a>';
                                        var linkrepp    = '<a class="link" href="'+$("#url").val()+'venta/impresion_reparto/'+cod_ven+'" target="_blank"><small>Ticket reparto</small></a>';
                                        // Agregar el botón "GAVETA" al lado del botón "Imprimir Comprobante"
                                        var linkgaveta = '<a class="link" href="' + $("#url").val() + 'imprimir/gaveta.php" target="_blank"><i class="fas fa-print text-muted"></i></a>';
                                        var linkgavetap = '<a class="link" href="' + $("#url").val() + 'imprimir/gaveta.php" target="_blank"><small>GAVETA</small></a>';                                        
                                    }else{
                                        // vista previa
                                        var linkrep     = '<a class="link" onclick="printPdf(\''+urlticketreparto+'\',true);" href="javascript:void(0)"><i class="fas fa-print text-muted"></i></a>';
                                        var linkrepp    = '<a class="link" onclick="printPdf(\''+urlticketreparto+'\',true);" href="javascript:void(0)"><small>Ticket reparto</small></a>';
                                        var linkpdf     = '<a href="'+$("#url").val()+'informe/venta_all_imp_/'+cod_ven+'" target="_blank"><i class="mdi mdi-receipt text-muted"></i></a>';
                                         //var linkpdff    = '<a class="link" href="javascript:void(0)" onclick="printPdf('+cod_ven+');"><small>Imprimir comprobante</small></a>';
                                        var linkpdff    = '<a class="link" href="'+$("#url").val()+'informe/venta_all_imp_/'+cod_ven+'" target="_blank"><small>Imprimir comprobante</small></a>';
                                        // Agregar el botón "GAVETA" al lado del botón "Imprimir Comprobante"
                                        var linkgaveta = '<a class="link" href="' + $("#url").val() + 'imprimir/gaveta.php" target="_blank"><i class="fas fa-print text-muted"></i></a>';
                                        var linkgavetap = '<a class="link" href="' + $("#url").val() + 'imprimir/gaveta.php" target="_blank"><small>GAVETA</small></a>';
                                    }

                                    if($('#codtipoped').val() == 3){
                                        html_confirm =  '<div class="row"> <div class="col-'+cantcolumn+' col-md-'+cantcolumn+'">'
                                        +'<div class="text-center p-20"><i class="fas fa-check-circle display-3 text-success"></i>'
                                        +'<h4 class="m-t-20 font-bold">¡Venta completada!</h4></div>'
                                        +'<div class="card-body text-center">'
                                            +'<div class="row">'
                                                +'<div class="col-6 text-center">'
                                                    +'<h1 class="font-light m-b-0">'+linkpdf+'</h1>'
                                                    +''+linkpdff+''
                                                +'</div>'
                                                +'<div class="col-6 text-center">'
                                                    +'<h1 class="font-light m-b-0">'+linkgaveta+'</h1>'
                                                    +''+linkgavetap+''
                                                +'</div>' 
                                                +'<div class="col-6 text-center">'
                                                    +'<h1 class="font-light m-b-0">'+linkrep+'</h1>'
                                                    +''+linkrepp+''
                                                +'</div>'
                                            +'</div>'
                                            +'<div class="row mt-5">'
                                                +'<div class="col-12 text-center">'
                                                    +'<span class="mb-2 text-center" style="display: block;">Enviar comprobante por WhatsApp</span>'
                                                    +'<div class="input-group">'
                                                        +'<div class="input-group-prepend">'
                                                            +'<span class="input-group-text">Nº</span>'
                                                        +'</div>'
                                                        +'<input type="text" id="numero_cliente" value="51" class="form-control" placeholder="51999999999" aria-label="51999999999" aria-describedby="button-addon2">'
                                                        +'<div class="input-group-append">'
                                                            +'<button class="btn btn-success" type="button" id="button-addon2" onclick="clickSendWhatsapp('+cod_ven+');">enviar <i class="fab fa-whatsapp"></i></button>'
                                                        +'</div>'
                                                    +'</div>'
                                                    // +'<div class="input-group mt-1">'
                                                    //     +'<div class="input-group-prepend">' 
                                                    //         +'<span class="input-group-text">@</span>'
                                                    //     +'</div>'
                                                    //     +'<input type="text" id="correo_cliente" value="" class="form-control" placeholder="cliente@dominio.com" aria-label="cliente@dominio.com" aria-describedby="button-addon2">'
                                                    //     +'<div class="input-group-append">'
                                                    //         +'<button class="btn btn-success" type="button" id="button-SendEmail" onclick="clickSendEmail('+ cod_ven+',\''+$("#entorno").val()+'/\');">enviar <i class="fa fa-envelope"></i></button>'
                                                    //     +'</div>'
                                                    // +'</div>'
                                                    //     +'<code style="display:inline-block" id="msj-SendEmail">Enviando email, espere por favor</code>'
                                                +'</div>'
                                            +'</div>'
                                        +'</div>'
                                        +'</div>'
                                        +''+Urlpdfiframe+''
                                        // +'<iframe src="'+Urlpdfiframe+'#toolbar=0" style="border:none;width: 100%;height: 100%;" />' //
                                        +'</div>';

                                    } else {
                                        html_confirm = '<div class="row"> <div class="col-'+cantcolumn+' col-md-'+cantcolumn+'">'
                                        +'<div class="text-center p-20"><i class="fas fa-check-circle display-3 text-success"></i>'
                                        +'<h4 class="m-t-20 font-bold">¡Venta completada!</h4></div>'
                                        +'<div class="card-body text-center">'
                                            +'<div class="row">'
                                                +'<div class="col-12 text-center">' 
                                                    +'<h1 class="font-light m-b-0">'+linkpdf+'</h1>'
                                                    +''+linkpdff+''
                                                +'</div>'
                                                +'<div class="col-12 text-center">'
                                                    +'<h1 class="font-light m-b-0">'+linkgaveta+'</h1>'
                                                    +''+linkgavetap+''
                                                +'</div>'
                                            +'</div>'
                                            +'<div class="row mt-5">'
                                                +'<div class="col-12 text-center">'
                                                    +'<span class="mb-2 text-center" style="display: block;">Enviar comprobante por WhatsApp</span>'
                                                    +'<div class="input-group">'
                                                        +'<div class="input-group-prepend">'
                                                            +'<span class="input-group-text">Nº</span>'
                                                        +'</div>'
                                                        +'<input type="text" id="numero_cliente" value="51" class="form-control" placeholder="51999999999" aria-label="51999999999" aria-describedby="button-addon2">'
                                                        +'<div class="input-group-append">'
                                                            +'<button class="btn btn-success" type="button" id="button-addon2" onclick="clickSendWhatsapp('+cod_ven+');">enviar <i class="fab fa-whatsapp"></i></button>'
                                                        +'</div>'
                                                    +'</div>'
                                                    // +'<div class="input-group mt-1">'
                                                    //     +'<div class="input-group-prepend">'
                                                    //         +'<span class="input-group-text">@</span>'
                                                    //     +'</div>'
                                                    //     +'<input type="text" id="correo_cliente" value="" class="form-control" placeholder="cliente@dominio.com" aria-label="cliente@dominio.com" aria-describedby="button-addon2">'
                                                    //     +'<div class="input-group-append">'
                                                    //         +'<button class="btn btn-success" type="button" id="button-SendEmail" onclick="clickSendEmail('+ cod_ven+',\''+$("#entorno").val()+'/\');">enviar <i class="fa fa-envelope"></i></button>'
                                                    //     +'</div>'
                                                    // +'</div>'
                                                    //     +'<code style="display:none" id="msj-SendEmail">Enviando email, espere por favor</code>'
                                                +'</div>'
                                            +'</div>'
                                        +'</div>'
                                        +'</div>'
                                        +''+Urlpdfiframe+''
                                        // +'<iframe src="'+Urlpdfiframe+'#toolbar=0" style="border:none;width: 100%;height: 100%;" />' //
                                        +'</div>';

                                    }
                                    Swal.fire({
                                        html: html_confirm,
                                        width: withmodal,
                                        footer: '<div><a class="btn btn-orange" href="'+html_footer+'" target="_self">Continuar <i class="fas fa-arrow-right"></i></a></div>',
                                        allowOutsideClick: false,
                                        allowEscapeKey : false,
                                        showCancelButton: false,
                                        showConfirmButton: false,
                                        closeOnConfirm: false,
                                        closeOnCancel: false,
                                        //backdrop: '#34d16e'
                                    });
                                    $('.swal2-modal').addClass('card-shadow');

                                    if($('#codtipoped').val() == 2){
                                        // impresion_ticket($('#id_pedido').val());
                                    }
                                    
                                    if($('input:radio[name="tipo_doc"]:checked').val() == 3){
                                        window.open($("#url").val()+'informe/venta_all_imp_/'+cod_ven, '_blank');
                                    }
                                
                                }
                            },
                            error: function(jqXHR, textStatus, errorThrown){
                                console.log(errorThrown + ' ' + textStatus);
                            }   
                        });
            }


        }
    });

    $('#form-editar-venta-pago')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    
    tipo_pago = $('#id_venta_tipopago').val();
    id_venta = $('#id_venta').val();
    id_tipo_pago = $('#id_tipo_pago_v').val();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/venta_edit_pago',
        data: {
            id_venta: id_venta,
            id_tipo_pago: id_tipo_pago,
            tipo_pago: tipo_pago
        },
        success: function (cod) {
            $('#modal-editar-venta-pago').modal('hide');
            Swal.fire({   
                title:'Proceso Terminado',   
                text: 'Datos actualizados correctamente',
                icon: "success", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            delivery_list_c();
            listarPedidosDetalle(3,$('#id_pedido').val(),id_venta);        
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }    
    });
        return false;
    });

    $("#telefono_cliente").autocomplete({
        delay: 1,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                url: $('#url').val()+'venta/buscar_cliente_telefono',
                type: "post",
                dataType: "json",
                data: {
                    cadena: request.term
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        tipo_cli = (item.tipo_cliente == 1) ? $("#diAcr").val() : $("#tribAcr").val();
                        // console.log(item)
                        return {
                            id_cliente: item.id_cliente,
                            nombre: item.nombre,
                            telefono: item.telefono,
                            direccion: item.direccion,
                            referencia: item.referencia,
                            tipo_cliente: item.tipo_cliente,
                            ruc: item.ruc,
                            dni: item.dni,
                            //label: tipo_cli+': '+item.dni+''+item.ruc,
                            value: item.telefono
                        }
                    }))
                }
            })
        },
        select: function (e, ui) {
            //$("#documento_cliente").val('');
            $("#cliente_id").val(ui.item.id_cliente);
            /////////////////////////////////////////////
            $('.display-nombre').css('display','block');
            //$('.display-telefono-cliente').css('display','block');
            $("#nomb_cliente").removeAttr('disabled');
            //$("#telefono_cliente").removeAttr('disabled');
            /////////////////////////////////////////
            if($('input:radio[name=tipo_entrega]:checked').val() == 1){
                $('.display-direccion-cliente').css('display','block');
                $('.display-referencia-cliente').css('display','block');
                $('.display-repartidor').css('display','block');
                $("#direccion_cliente").removeAttr('disabled');
                $("#referencia_cliente").removeAttr('disabled');
                $("#id_repartidor").removeAttr('disabled');
            } else {
                $('.display-direccion-cliente').css('display','none');
                $('.display-referencia-cliente').css('display','none');
                $('.display-repartidor').css('display','none');
                $("#direccion_cliente").attr('disabled','true');
                $("#referencia_cliente").attr('disabled','true');
                $("#id_repartidor").attr('disabled','true');
            }
            ////////////////////////////////////////////
            $("#telefono_cliente").val(ui.item.telefono);
            $("#nomb_cliente").val(ui.item.nombre);
            $("#nomb_cliente").val(ui.item.nombre);
            $("#direccion_cliente").val(ui.item.direccion);
            $("#referencia_cliente").val(ui.item.referencia);

            $("#num_cliente").val(ui.item.tipo_cliente == 1 ? ui.item.dni : ui.item.ruc);
            $('#id_tdoc').selectpicker('val', ui.item.tipo_cliente);
            $('#id_tdoc').selectpicker('refresh');

            $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
            //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-info" onclick="editar_cliente('+ui.item.id_cliente+');" type="button"><i class="fa fa-user"></i></button>');
        },
        change: function(e, ui) {
            $("#documento_cliente").val('');
        }
    })
    .autocomplete( "instance" )._renderItem = function( ul, item ) {
        return $( "<li class='ui-menu-item'></li>" )
            .data( "item.autocomplete", item )
            .append( "<div class='ui-menu-item-wrapper'>" + item.nombre+"<br>Telefono/Celular: "+item.telefono+"</div>" )
            .appendTo( ul );
    };
    
    /*
    var minlength = 1;
    $("#telefono_cliente").keyup(function () {
        var that = this,
        value = $(this).val();
        if (value.length < minlength ) {
            //$("#cliente_id").val('');
            //////////////////////////////////////////////
            //$('.display-nombre').css('display','none');
            //$('.display-telefono-cliente').css('display','none');
            //$('.display-direccion-cliente').css('display','none');
            //$('.display-referencia-cliente').css('display','none');
            //$('.display-repartidor').css('display','none');
            //$("#nomb_cliente").attr('disabled','true');
            //$("#telefono_cliente").attr('disabled','true');
            //$("#direccion_cliente").attr('disabled','true');
            //$("#referencia_cliente").attr('disabled','true');
            $('#id_repartidor').selectpicker('refresh');
            $('#id_repartidor').selectpicker('val', '');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
            ////////////////////////////////////////////
            $("#telefono_cliente").val('');
            $("#nomb_cliente").val('');
            $("#direccion_cliente").val('');
            $("#referencia_cliente").val('');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
            //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-secondary" onclick="nuevo_cliente();" type="button"><i class="fa fa-user-plus"></i></button>');
        }
    });
    */
});

var mesa_list = function(cod){
    $('.list-mesas').empty();
    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/mesa_list',
        success: function (item) {
            var count = 0,
                count_disponibles = 0,
                count_ocupadas = 0,
                count_pagos = 0;

            $.each(item['mesa'], function(i, mesa) {
    
                x = (mesa.estado == 'a') ? count_disponibles++ : 'NINGUNO';
                y = (mesa.estado == 'p') ? count_pagos++ : 'NINGUNO';
                z = (mesa.estado == 'i') ? count_ocupadas++ : 'NINGUNO';

                forma = (mesa.forma == 1) ? '' : 'rounded-circle';

                if($('#rol_usr').val() == 5){

                    if(mesa.id_salon == cod && mesa.estado == 'a'){
                        $('.list-mesas')
                            .append($('<button class="btn btn-green '+forma+' dim btn-large-dim"'
                                +'onclick="registrarMesa('+mesa.id_mesa+',\''+mesa.nro_mesa+'\',\''+mesa.desc_salon+'\');">'+mesa.nro_mesa+'<br><img src="public/images/table_empty.png" width="40px" height="40px"/><input type="radio" autocomplete="off"></button>'));
                    } else if(mesa.id_salon == cod && mesa.estado == 'p'){
                        $('.list-mesas')
                            $('.list-mesas')
                            .append($('<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>'
                                +'<button class="btn btn-blue '+forma+' dim btn-large-dim"'
                                +'onclick="orden('+mesa.id_pedido+')">'
                                +'<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span><span>'+mesa.nro_mesa+'</span><br><img src="public/images/table_full.png" width="40px" height="40px"/>'
                                +'<span class="span-b"><i class="ti-timer"></i>&nbsp;<span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span><input type="radio" autocomplete="off"></button>'));
                    } else if(mesa.id_salon == cod && mesa.estado == 'i'){
                        $('.list-mesas')
                            .append($('<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>'
                                +'<button class="btn btn-reed '+forma+' dim btn-large-dim"'
                                +'onclick="orden('+mesa.id_pedido+')">'
                                +'<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span><span>'+mesa.nro_mesa+'</span><br><img src="public/images/table_full.png" width="40px" height="40px"/>'
                                +'<span class="span-b"><i class="ti-timer"></i>&nbsp;<span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span><input type="radio" autocomplete="off"></button>'));
                    }

                } else{

                    if(mesa.id_salon == cod && mesa.estado == 'a'){
                        $('.list-mesas')
                            .append($('<button class="btn btn-green '+forma+' dim btn-large-dim"'
                                +'onclick="nuevoPedidoMesa('+mesa.id_mesa+',\''+mesa.nro_mesa+'\',\''+mesa.desc_salon+'\')">'+mesa.nro_mesa+'<br><img src="public/images/table_empty.png" width="40px" height="40px"/><input type="radio" autocomplete="off"></button>'));
                    } else if(mesa.id_salon == cod && mesa.estado == 'p'){
                        $('.list-mesas')
                            $('.list-mesas')
                            .append($('<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>'
                                +'<button class="btn btn-blue '+forma+' dim btn-large-dim"'
                                +'onclick="listarPedidos('+mesa.id_salon+','+mesa.id_mesa+',1,'+mesa.id_pedido+',\''+mesa.nro_mesa+'\',\''+mesa.desc_salon+'\',\''+mesa.estado+'\')">'
                                +'<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span><span>'+mesa.nro_mesa+'</span><br><img src="public/images/table_full.png" width="40px" height="40px"/>'
                                +'<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span><input type="radio" autocomplete="off"></button>'));
                    } else if(mesa.id_salon == cod && mesa.estado == 'i'){
                        $('.list-mesas')
                            .append($('<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>'
                                +'<button class="btn btn-reed '+forma+' dim btn-large-dim"'
                                +'onclick="listarPedidos('+mesa.id_salon+','+mesa.id_mesa+',1,'+mesa.id_pedido+',\''+mesa.nro_mesa+'\',\''+mesa.desc_salon+'\',\''+mesa.estado+'\')">'
                                +'<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span><span>'+mesa.nro_mesa+'</span><br><img src="public/images/table_full.png" width="40px" height="40px"/>'
                                +'<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span><input type="radio" autocomplete="off"></button>'));
                    }
                }

            });
            $('.mesas-disponibles').attr('data-original-title',count_disponibles+' mesas disponibles');
            $('#mesa_libre').text(count_disponibles);
            $('.mesas-ocupadas').attr('data-original-title',count_ocupadas+' mesas ocupadas');
            $('#mesa_ocupada').text(count_ocupadas);
            $('.mesas-pago').attr('data-original-title',count_pagos+' mesas en proceso de pago');
            $('#mesa_proceso').text(count_pagos);
        }
    });
}

var tiempo_mesa = function(){
    moment.locale('es');
    $('input[name^="tiempo_mesa"]').each(function(i) {
        var fechaConvertida = moment($(this).val()).fromNow(true);
        $(".hora-mesa"+i).text(fechaConvertida);
    });
}

var mostrador = function(){
    //mostrador_list_a();
    //mostrador_list_c();
    activaTab('mostrador01');
    mostrador_list_a();
    $('.pedido-mozo').hide();
}

var mostrador_list_a = function(){
    
    function filterGlobal () {
    $('#list-mostrador-confirmacion').DataTable().search( 
    $('#search_filter_e').val()
    ).draw();
    }
    
    var count = 0;
    var table = $('#list-mostrador-confirmacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list",
            "data": {
                estado: 'a'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_pedido_mostrador[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-pedido-mostrador'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.Total.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
        }
    });
    
    $('input.search_filter_e').on( 'keyup click', function () {
      filterGlobal();
  });
}

var mostrador_list_b = function(){
    
    function filterGlobal () {
    $('#list-mostrador-preparacion').DataTable().search( 
    $('#search_filter_f').val()
    ).draw();
    }
    
    var count = 0;
    var table = $('#list-mostrador-preparacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list_c",
            "data": {
                estado: 'b'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_preparacion_mostrador[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-preparacion-mostrador'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.id_tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
        }
    });
    
    $('input.search_filter_f').on( 'keyup click', function () {
      filterGlobal();
  });
}

var mostrador_list_c = function(){

    function filterGlobal () {
    $('#list-mostrador-entregados').DataTable().search( 
    $('#search_filter_g').val()
    ).draw();
    }
    
    var table = $('#list-mostrador-entregados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list_c",
            "data": {
                estado: 'd'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_entrega);
                var fecha2 = moment(data.fecha_pedido);
                var duration = moment.duration(fecha2 - fecha1).humanize();
                return '<i class="ti-arrow-up text-warning"></i> '+moment(data.fecha_pedido).format('h:mm A')
                    +'<br><i class="ti-arrow-down text-success"></i> '+moment(data.fecha_entrega).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.id_tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.id_tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
        }
    });
    
    $('input.search_filter_g').on( 'keyup click', function () {
      filterGlobal();
  });
}

var delivery = function(){
    activaTab('delivery01');
    delivery_list_a();
    $('.pedido-mozo').hide();
}

var count_pedido_delivery = 0;
var countNuevoPedidoDelivery = function(){
    $.ajax({     
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/delivery_list',
        data: {
            estado : 'a'
        },
        success: function (data){
            $.each(data, function(i, item) {
                if(parseInt(item.length) !== count_pedido_delivery){
                    count_pedido_delivery = 0;
                    if($('#codpestdelivery').val() == 1){
                        delivery_list_a();
                    }
                    var sound = new buzz.sound($('#url').val()+"public/sound/ding_ding", {
                        formats: [ "ogg", "mp3", "aac" ]
                    });
                    sound.play();
                    count_pedido_delivery = item.length + count_pedido_delivery;
                    $('.pedidos-total-1').text(count_pedido_delivery);
                }
            });
        }
    })
}

var delivery_list_a = function(){
    
    function filterGlobal () {
    $('#list-delivery-confirmacion').DataTable().search( 
    $('#search_filter_a').val()
    ).draw();
    }
    
    var count = 0;
    var table = $('#list-delivery-confirmacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list",
            "data": {
                estado: 'a'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                if(data.pedido_programado == 1){
                    return '<a href="javascript::void(0)"><span class="round round-primary" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
                } else {
                    return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
                }
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_pedido_delivery[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-pedido-delivery'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                var sumatoria = Number(data.Total.total) + Number(data.comision_delivery);
                return moneda+' '+ sumatoria;
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
            $('.pedidos-total-1').text(total);
        }
    });
    
    $('input.search_filter_a').on( 'keyup click', function () {
      filterGlobal();
  });
}


var limpiar_pagos_a = function(){
    $('#pago_efe').val('0.00');
    $('#pago_tar').val('0.00');
    $('#pago_yape').val('0.00');
    $('#pago_plin').val('0.00');
    $('#pago_tran').val('0.00');
    $('#vuelto').text('0.00');
}

var delivery_list_b = function(){

    function filterGlobal () {
    $('#list-delivery-preparacion').DataTable().search( 
    $('#search_filter_b').val()
    ).draw();
    }
    
    var count = 0;
    var table = $('#list-delivery-preparacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list",
            "data": {
                estado: 'b'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_preparacion_delivery[]" value="'+data.fecha_preparacion+'"/><i class="ti-timer"></i> <span class="tiempo-preparacion-delivery'+count+++'">'+moment(data.fecha_preparacion).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                var sumatoria = Number(data.Total.total) + Number(data.comision_delivery);
                return moneda+' '+ sumatoria;
                // return moneda+' '+formatNumber(data.Total.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
        }
    });
    
    $('input.search_filter_b').on( 'keyup click', function () {
      filterGlobal();
  });
}

var delivery_list_c = function(){

    function filterGlobal () {
    $('#list-delivery-enviados').DataTable().search( 
    $('#search_filter_c').val()
    ).draw();
    }
    
    var table = $('#list-delivery-enviados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list_c",
            "data": {
                estado: 'c'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_envio);
                var fecha2 = moment(data.fecha_pedido);
                var duration = moment.duration(fecha2 - fecha1).humanize();
                return '<i class="ti-arrow-up text-warning"></i> '+moment(data.fecha_pedido).format('h:mm A')
                    +'<br><i class="ti-arrow-down text-info"></i> '+moment(data.fecha_envio).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago_new == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
            //$('#idventa').val(idventa);
        }
    });
    
    $('input.search_filter_c').on( 'keyup click', function () {
      filterGlobal();
  });
}

var delivery_list_d = function(){

    function filterGlobal () {
    $('#list-delivery-entregados').DataTable().search( 
    $('#search_filter_d').val()
    ).draw();
    }
    
    var table = $('#list-delivery-entregados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list_c",
            "data": {
                estado: 'd'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
        return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_entrega);
                var fecha2 = moment(data.fecha_envio);
                var fecha3 = moment(data.fecha_preparacion);
                if(data.fecha_envio == '0000-00-00 00:00:00'){
                    var fecha_i = fecha3;
                } else {
                    var fecha_i = fecha2;
                }
                var duration = moment.duration(fecha_i - fecha1).humanize();
                return '<i class="ti-arrow-up text-info"></i> '+fecha_i.format('h:mm A')
                    +'<br><i class="ti-arrow-down text-success"></i> '+moment(data.fecha_entrega).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago_new == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago_new >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
        }
    });
    
    $('input.search_filter_d').on( 'keyup click', function () {
      filterGlobal();
  });
}

var tiempo_pedido = function(){
    moment.locale('es');
    $('input[name^="tiempo_pedido_mostrador"]').each(function(i) {
        var fechaConvertida_mostrador_a = moment($(this).val()).fromNow(true);
        $(".tiempo-pedido-mostrador"+i).text(fechaConvertida_mostrador_a);
    });
    $('input[name^="tiempo_pedido_delivery"]').each(function(i) {
        var fechaConvertida_delivery_a = moment($(this).val()).fromNow(true);
        $(".tiempo-pedido-delivery"+i).text(fechaConvertida_delivery_a);
    });
}

var tiempo_preparacion = function(){
    moment.locale('es');
    $('input[name^="tiempo_preparacion_mostrador"]').each(function(i) {
        var fechaConvertida_mostrador_b = moment($(this).val()).fromNow(true);
        $(".tiempo-preparacion-mostrador"+i).text(fechaConvertida_mostrador_b);
    });
    $('input[name^="tiempo_preparacion_delivery"]').each(function(i) {
        var fechaConvertida_delivery_b = moment($(this).val()).fromNow(true);
        $(".tiempo-preparacion-delivery"+i).text(fechaConvertida_delivery_b);
    });
}

var listarPedidos = function(cod_salon,cod_mesa,id_tipo_pedido,id_pedido,mesa,salon,estado){


    $('#codsalonorigen').val(cod_salon);
    $('#codmesaorigen').val(cod_mesa);
    reset_default();
    $('.card_height').css('background','#fffde3');
    $('.card-body-right').css('display','block');
    $('.display-opciones-pedido').hide();
    if(id_tipo_pedido == 1){
        $('.pedido-numero-icono').html('');
        $('.pedido-numero').html(salon+' - Mesa: '+mesa);
    } 
    $('.cont03').css('display','block');

    
    $('.imprimir_precuenta').on('click', function() {
        impPreCuenta(id_pedido, cod_mesa, estado , true);
    });

    $('#list-pedidos').empty();
    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/listarPedidos',
        data: {
            id_pedido: id_pedido,
            codpagina: $('#codpagina').val()
        },
        success: function (data) {
            var totPed = 0,
                total = 0;
            if (data.length != 0) {
                $.each(data, function(i, item) {
                    $('#nombre_mozo').val(item.nombre_mozo);
                    $('.pedido-mozo').show();
                    $('.pedido-mozo').attr('data-original-title','Mozo: '+item.nombre_mozo);
                    totPed = (item.cantidad * item.precio);
                    $('#list-pedidos')
                    .append(
                        $('<div class="d-flex flex-row comment-row comment-list" onclick="subPedido(1,'+item.id_pedido+','+item.id_pres+',\''+item.precio+'\');"/>')
                        .append('<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">'
                        +'<h6 class="m-b-5">'+item.Producto.pro_nom+' <span class="label label-warning">'+item.Producto.pro_pre+'</span></h6>'
                        +'<p class="m-b-0 font-13">'+item.cantidad+' Unidad(es) en '+moneda+' '+formatNumber(item.precio)+' | Unidad</p></span>'
                        +'<span class="price">'+moneda+' '+formatNumber(totPed)+'</span></div>'));
                    total = totPed + total;    
                });
                $('.totalPagar').html('<div class="text"><span>'+moneda+' '+formatNumber(total)+'</span>');
            } else {
                $('#list-pedidos').html('<div class="justify-center" style="height: 100%;"><div class="text-center"><h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2><h4 style="color: #d3d3d3;">Agregue productos</h4><h6 style="color: #d3d3d3;">No se encontraron productos</h6></div></div>');
                $('.totalPagar').html('<div class="text"><span>'+moneda+' '+formatNumber(total)+'</span>');
            }
        }
    });
    $('.card-footer-right').css('display','block');
    $('.btn-submit-nuevo-pedido').html('<a class="btn btn-orange" href="'+$('#url').val()+'venta/orden/'+id_pedido+'">Continuar <i class="fas fa-arrow-right"></i></a>');
    $('.btn-submit-dividir-cuenta').html('<a class="btn btn-blue btnDividirCuenta" id="btnDividirCuenta" data-id-pedido="'+id_pedido+'" data-id-mesa="'+cod_mesa+'" href="javascript:void(0);">Dividir Cuenta</a>');
    $('#btnDividirCuenta').on('click', function(event) {
        event.preventDefault();  // Evitar redirección
        var id_pedido = $(this).data('id-pedido');

        conf_dividir(id_pedido, 2, id_tipo_pedido);
        
    });

    // Botón "Cobrar" sin redirección
    $('.btn-submit-cobrar').html('<a class="btn btn-green btnCobrar" id="btnCobrar" data-id-pedido="'+id_pedido+'" data-id-mesa="'+cod_mesa+'" href="javascript:void(0);">Cobrar</a>');
    $('#btnCobrar').on('click', function(event) {
        event.preventDefault();  // Evitar redirección
        var id_pedido = $(this).data('id-pedido');
        facturar(id_pedido, 1, id_tipo_pedido);
    });
}

var conf_dividir = function(id_pedido,dividir_cuenta){
   
    Swal.fire({
        title: 'Confirmación',
        html: "¿Desea dividir cuenta?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true
    }).then((result) => {
        if (result.value) {
            facturar(id_pedido,dividir_cuenta)
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            return false
        }
    });
    
}


var facturar = function(id_pedido,dividir_cuenta, id_tipo_pedido){

    $("#btn-submit-facturar").removeAttr('disabled');
    $('#list-items-facturar').empty();
    $('#id_pedido').val(id_pedido);
    $('#dividir_cuenta').val(dividir_cuenta);
    var tipo_pedido = $('#codtipoped').val();
    var moneda = $("#moneda").val();

    defaultdata(id_pedido,id_tipo_pedido);

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/ListarDetallePed',
        data: {
            id_pedido: id_pedido, 
            tipo_pedido: tipo_pedido
        },
        success: function (data) {
            var sub_total = 0;
            var total = 0;
            var precio_imp_bol = 0;

            
            $.each(data.Detalle, function(i, item) {
                var totped = $("#total_pedido").val();
                var imp_bol = $("#imp_icbper").val();

                if (item.Producto.impuesto_icbper == "1") {
                  precio_imp_bol = parseFloat(item.cantidad * imp_bol) + parseFloat(precio_imp_bol);
                } else {
                  precio_imp_bol = parseFloat(precio_imp_bol);
                }

                var calc = (item.cantidad * item.precio).toFixed(2);
                sub_total = (parseFloat(item.cantidad * precio_imp_bol)) + (parseFloat(sub_total));

                total = parseFloat(sub_total) + parseFloat(total);

                if (1 == dividir_cuenta && item.cantidad > 0){
                    $(".icbper").text(formatNumber(imp_bol));
                    $(".totalPedido").val(totped);
                    $(".totalPedido").text(formatNumber(totped));
                    $(".subtotal").text(formatNumber(totped));
                    $("#total_venta").val(totped);
                    $('.btn-cancel-facturar-1').show();
                    $('.btn-cancel-facturar-2').hide();
                    calculo_total();
                    calculo_efectivo();
                    $('#list-items-facturar')
                    .append(
                    $('<tr class="comment-list"/>')
                        .append(
                            $('<td width="20%"/>')
                            .html('<input type="hidden" name="cantProd[]" value="'+item.cantidad+'"/>'
                                +'<input type="hidden" name="precProd[]" value="'+item.precio+'"/>'
                                +item.cantidad)
                            )
                        .append(
                            $('<td width="60%"/>')
                            .html('<input type="hidden" name="idProd[]" value="'+item.id_pres+'"/>'
                                +item.Producto.pro_nom+' <span class="label label-warning text-uppercase">'+item.Producto.pro_pre+'</span>')
                            )
                        .append(
                            $('<td width="20%" class="text-right"/>')
                            .html(moneda+' '+formatNumber(calc))
                            )
                    );
                } else if (2 == dividir_cuenta && item.cantidad > 0){
                    limpiar_datos_add();
                    $('.display-pago-rapido-efectivo').show();
                    $(".totalPedido").val('0.00');
                    $(".totalPedido").text('0.00');
                    $("#total_venta").val('0.00');
                    $(".subtotal").text('0.00');
                    $('.btn-cancel-facturar-1').hide();
                    $('.btn-cancel-facturar-2').show();
                    calculo_total();
                    $(".opc-01").text('0.00');
                    $('#list-items-facturar')
                    .append(
                    $('<tr class="comment-list priceU" data-price="'+item.precio+'" style="cursor: pointer;"/>')
                        .append(
                            $('<td width="20%"/>')
                            .html('<input type="hidden" class="cantidad" name="cantProd[]" value="0"/>'
                                +'<input type="hidden" name="precProd[]" value="'+item.precio+'"/>'
                                +'<input type="hidden" value="'+item.cantidad+'" class="cantOrg"/>'
                                +'<input type="hidden" value="1" class="cantTemp"/>'
                                +'<b></b> '+item.cantidad)
                            )
                        .append(
                            $('<td width="60%"/>')
                            .html('<input type="hidden" name="idProd[]" value="'+item.id_pres+'"/>'
                                +item.Producto.pro_nom+' <p class="label label-warning text-uppercase">'+item.Producto.pro_pre+'</p>')
                            )
                        .append(
                            $('<td width="20%" class="text-right"/>')
                            .html(moneda+' <span>0.00</span>')
                            )
                    );
                }
            });

            $(".subtotal").text(formatNumber(sub_total));
            $(".icbper").text(formatNumber(precio_imp_bol));
            $("#monto_icbper").val(parseFloat(precio_imp_bol));

            $(".priceU").on("click",function(){
                var totalTemp = $(this).find(".cantTemp").val();
                $(this).css('cssText','background: #f9e79f !important; color: #424949 !important; cursor: pointer;');
                $(this).find(".cantTemp").val(parseInt(totalTemp)+1);
                var totalCant = $(this).find(".cantOrg").val();
                var cantB = parseInt(totalCant) - 1;
                $(this).find("b").text(totalTemp+' /');
                var valorItem = $(this).find("span").text();
                var valorPrice = $(this).attr("data-price");
                var totalItem = (parseFloat(valorItem)+parseFloat(valorPrice)).toFixed(2);
                $(this).find("span").text(totalItem);
                var totalGneral=0;
                $(this).find(".cantidad").val(totalTemp);
                if(parseInt(totalCant) < parseInt(totalTemp)){
                    $(this).find(".cantTemp").val(1);
                    $(this).css('cssText','background: transparent !important; cursor:pointer;');
                    $(this).find("span").text('0.00');
                    $(this).find("b").text('');
                    $(this).find(".cantidad").val(0);
                }
                $(".priceU").each(function() {
                  totalGneral += parseFloat($( this ).find("span").text());
                });
                $(".totalPedido").val((totalGneral).toFixed(2));
                $(".totalPedido").text(formatNumber(totalGneral));
                $('.totalPedidoMenosTarjeta').text(formatNumber(totalGneral));
                $("#total_venta").val(totalGneral);
                $(".subtotal").text(formatNumber(totalGneral));
                $("#btn-submit-facturar").removeAttr('disabled');
                $("#btn-submit-facturar").removeClass('disabled');
                limpiar_datos_add();
                $("#pago_efe").val((totalGneral).toFixed(2));
                $(".opc-01").text((totalGneral).toFixed(2));
            });
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }   
    });
    $("#modal-facturar").modal('show');
}


var defaultdata = function(id_pedido, id_tipo_pedido){
    
    $.ajax({
        async: false,
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/defaultdata',
        data: {
            id_pedido: id_pedido,
            tipo_pedido: id_tipo_pedido
        },
        success: function (data) {
            var sbtot = 0;
            var total = 0;


          var imp_bol = $("#imp_icbper").val();
          $.each(data.Detalle, function (i, item) {
            var precio_imp_bol = 0;

            if (item.impuesto_icbper == "1") {
              precio_imp_bol = parseFloat(item.precio) + parseFloat(imp_bol);
            } else {
              precio_imp_bol = item.precio;
            }

            var importe = parseFloat(item.cantidad * precio_imp_bol) ;
            if (item.estado != "i" && item.cantidad > 0) {
              sbtot = parseFloat(importe) + parseFloat(sbtot);
            }
          });

            total = parseFloat(sbtot) + parseFloat(total);

            $('#totalPagar').text(moneda+' '+formatNumber(total));
            $('.totalPagar').text(moneda+' '+formatNumber(total));
            $('#total_pedido').val(total.toFixed(2));
            $('#pago_efe').val(formatNumber(total));
            $('.opc-01').text(formatNumber(total));
            $('.totalPedidoMenosTarjeta').text(formatNumber(total));

            $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
                +'onclick="nuevoClienteVista();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"'
                +'data-placement="top">'
                    +'<span class="input-group-text bg-header">'
                        +'<small><i class="fas fa-user-plus"></i></small>'
                   +'</span>'
                +'</a>');

            if(total != '0.00'){
                if(data.id_tipo_pedido == 3){
                    // if(data.estado_pedido != 'a'){                            
                    //     $('#list-productos').css('visibility','hidden');
                    //     $('.opc1').css('display','block');
                    //     $('.opc2').css('display','none');   
                    // } else {
                        $('.opc1').css('display','none');
                        $('.opc2').css('display','none'); 
                        $('.opc3').css('display','block');
                        if($('#rol_usr').val() == 5){
                           $('.opc1').css('display','block'); 
                        }
                    // }
                } else {
                    $('.opc1').css('display','block');
                    $('.opc2').css('display','none'); 
                }
            }else{
                $('.opc1').css('display','none');
                $('.opc2').css('display','block');
            };
            
            if(data.id_tipo_pedido == 1){
                $('.pedido-numero-icono').text('');
                $('.pedido-cliente-icono').removeClass('far fa-user');
                $('.pedido-numero').text(data.desc_salon);
                $('#nombre_salon').val(data.desc_salon);
                $('#nombre_mozo').val(data.nombre_mozo);
                $('.pedido-cliente').text('MESA: '+data.nro_mesa);
                // if($("#print_pre").val() == 1){ // impresion por comanda
                //     $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\')" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button>'); 
                // }else{ // impresion por view print 
                //     $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button  onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\',true)" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button>');                    
                // }
                if($("#print_pre").val() == 1){ // impresion por comanda
                    $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\')" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button> <div class="btn-group" data-toggle="tooltip" title="Imprimir Comanda"><button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-print"></i></button><div class="dropdown-menu" id="list-comandas"></div></div>'); 
                }else{ // impresion por view print 
                    $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button  onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\',true)" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button> <div class="btn-group" data-toggle="tooltip" title="Imprimir Comanda"><button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-print"></i></button><div class="dropdown-menu" id="list-comandas"></div></div>');                    
                }
                $('#cliente_id').val(1);
                $('#buscar_cliente').val('DNI: 00000000 | PUBLICO EN GENERAL');
            }else if(data.id_tipo_pedido == 2 || data.id_tipo_pedido == 3){
                $('.pedido-numero-icono').text('Pedido: ');
                $('.pedido-cliente-icono').addClass('far fa-user');
                $('.pedido-numero').text(data.nro_pedido);
                $('#btn-confirmar').text('AÑADIR');
                if(data.id_tipo_pedido == 2){
                    $('.pedido-cliente').text(data.nombre_cliente);
                    $('.btn-imp').html('<a href="'+$("#url").val()+'venta?tip=2&cod='+$('#codped').val()+'&est='+data.estado_pedido+'" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de ventas"><i class="fas fa-desktop"></i></a>');
                    $('#cliente_id').val(1);
                    $('#buscar_cliente').val('DNI: 00000000 | PUBLICO EN GENERAL');
                }else if(data.id_tipo_pedido == 3){
                    //$('.mensaje-pago-2-text').html('PAGA CON: S/'+data.paga_con+'<br>COMISION DELIVERY: S/'+data.comision_delivery);
                    
                    $('.comision_delivery').val(data.comision_delivery);
                    $('.comision_delivery').text(formatNumber(data.comision_delivery));
                    $('#pago_efe').val(formatNumber(data.paga_con));
                    $(".opc-01").text(formatNumber(parseFloat(total) + parseFloat(data.comision_delivery)));
                    var tipo_entrega = (data.tipo_entrega == 1) ? 'c' : 'd';
                    $('#codtipopedentrega').val(tipo_entrega);
                    if(data.estado_pedido == 'a'){
                        $('.btn-imp').html('<a href="'+$("#url").val()+'venta?tip=3&cod='+$('#codped').val()+'&est='+data.estado_pedido+'" class="btn btn-orange" data-toggle="tooltip" data-placement="top" data-original-title="Continuar">Continuar <i class="fas fa-arrow-right"></i></a>');                    
                    } else if(data.estado_pedido == 'b'){
                        $('.btn-imp').html('<a href="'+$("#url").val()+'venta?tip=3&cod='+$('#codped').val()+'&est='+data.estado_pedido+'" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de ventas"><i class="fas fa-desktop"></i></a>');
                    } else{
                        $('#list-productos').css('visibility','hidden');  
                    }
                    //$('.pedido-cliente').text(data.desc_repartidor);
                    $('.pedido-cliente').text(data.nombre_cliente.substr(0,13));
                    $('#cliente_id').val(data.id_cliente);
                    $('#cliente_tipo').val(data.tipo_cliente);
                    $('#tipo_cliente').val(data.tipo_cliente);
                    var tipo = (data.tipo_cliente == 1) ? $('#diAcr').val() : $('#tribAcr').val();
                    $('#buscar_cliente').val(tipo+': '+data.dni_cliente+''+data.ruc_cliente+' | '+data.nombre_cliente);
                    //$('#buscar_cliente').val('PUBLICO EN GENERAL');
                    $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
                    +'onclick="editar_cliente('+data.id_cliente+');" data-original-title="Editar cliente" data-toggle="tooltip"'
                    +'data-placement="top">'
                        +'<span class="input-group-text bg-header">'
                            +'<small><i class="fas fa-user text-info"></i></small>'
                       +'</span>'
                    +'</a>');
                }
            }
            
            if (data.tipo_cliente == 2){
                $('.btn-tipo-doc-2').addClass('active');
                $("input[name=tipo_doc][value='2']").attr("checked",true);
            } else {

                $('.btn-tipo-doc-1').addClass('active');
                $("input[name=tipo_doc][value='1']").attr("checked",true);

                if($("input[name=tipo_doc][value='1']").length == false){
                    $('.btn-tipo-doc-3').addClass('active');
                    $("input[name=tipo_doc][value='3']").attr("checked",true);
                }
            }
    

            // $('.btn-tipo-doc-3').addClass('disabled');
            // $("input[name=tipo_doc][value='2']").attr("disabled",false);

            if (data.tipo_pago == 1){
                $('#tipo_pago').selectpicker('val', data.tipo_pago);
                $('.mensaje-pago').hide();
                $('.display-pago-efectivo').show();
                $('.display-pago-tarjeta').hide();
                $('.display-pago-default').show();
                $('.display-pago-rapido-efectivo').show();
                $('.display-codigo-operacion').hide();
            } else if (data.tipo_pago != 3 && (data.tipo_pago == 2 || data.tipo_pago >= 4)) {
                $('#tipo_pago').selectpicker('val', data.tipo_pago);
                $('.mensaje-pago').hide();
                $('.display-pago-efectivo').hide();
                $('.display-pago-tarjeta').hide();
                $('.display-pago-default').hide();
                $('.display-pago-rapido-efectivo').hide();
                $('.display-descuento').show();
                $('.display-codigo-operacion').show();
            } else {
                $('#tipo_pago').selectpicker('val', 1);
                $('.mensaje-pago').hide();
                $('.display-pago-efectivo').show();
                $('.display-pago-tarjeta').hide();
                $('.display-pago-default').show();
                $('.display-pago-rapido-efectivo').show();
                $('.display-codigo-operacion').hide();
            }

            if(data.amortizacion > 0){
                $('.mensaje-amortizacion').show();
                $('.mensaje-amortizacion-text').html('Existe una amortizaci&oacute;n de pago con un monto de '+moneda+' '+formatNumber(data.amortizacion));
            } else {
                $('.mensaje-amortizacion').hide();
            }

            /*
            if(data.id_repartidor == 1){
                if (data.tipo_pago == 4) { 
                    $('.display-comision-delivery').hide(); 
                } else {
                    $('.display-comision-delivery').show();
                }
            } else {
                $('.display-comision-delivery').hide();
            }
            */
            if (data.tipo_pago == 4) { 
                $('.display-comision-delivery').hide(); 
            } else {
                $('.display-comision-delivery').show();
            }
            $('#codtipoped').val(data.id_tipo_pedido);
            $('.display-comision-tarjeta').hide();

            if(data.id_repartidor == 2222 || data.id_repartidor == 3333 || data.id_repartidor == 4444){
                $('#codrepartidor').val(2);
            } else {
                $('#codrepartidor').val(1);
            }
        }
    });
};

var limpiar_datos_add = function(){
    $('#pago_efe').val('0.00');
    $('#pago_tar').val('0.00');
    $('#pago_yape').val('0.00');
    $('#pago_plin').val('0.00');
    $('#pago_tran').val('0.00');
    $('#vuelto').text('0.00');
    $('.descuento').val('0.00');
    $('.descuento').text('0.00');
    $('.comision_delivery').val('0.00');
    $('.comision_delivery').text('0.00');
    $('.comision_tarjeta').val('0.00');
    $('.comision_tarjeta').text('0.00');
    $('.display-pago-efectivo').show();
    $('.display-pago-default').show();
    $('.display-pago-tarjeta').hide();
    $('#descuento_tipo_hidden').val('');
    $('#descuento_monto_hidden').val('0.00');
    $('#descuento_motivo_hidden').val('');
    $('#tipo_pago').selectpicker('val',1);
    $('.mensaje-pago').hide();
    $('.display-codigo-operacion').hide();
    $('.display-pago-rapido-efectivo').show();
}

var calculo_total = function(){
    
    if($("#descuento_monto_hidden").val() == ''){ $("#descuento_monto_hidden").val('0.00');}
    if($("#comision_delivery").val() == ''){ $("#comision_delivery").val('0.00');}
    
    var descuento = parseFloat($("#descuento_monto_hidden").val()) || 0.00;
    var comision_delivery = parseFloat($("#comision_delivery").val()) || 0.00;
    var total_venta = parseFloat($("#total_venta").val()) || 0.00;
    var comision_tarjeta = parseFloat($(".comision_tarjeta").val()) || 0.00;
    
    var calculo = total_venta + comision_delivery + comision_tarjeta - descuento;

    $(".totalPedido").val(formatNumber(calculo));
    $(".totalPedido").text(formatNumber(calculo));
    $('.totalPedidoMenosTarjeta').text(formatNumber(calculo));
    //console.log('calculo_total: '+calculo); 
}

var calculo_efectivo = function(){
    var cal1 = parseFloat($(".totalPedido").val().replace(',', "")) - parseFloat($("#pago_tar").val().replace(/,/g, ""))  - parseFloat($("#pago_yape").val().replace(/,/g, ""))  - parseFloat($("#pago_plin").val().replace(/,/g, ""))  - parseFloat($("#pago_tran").val().replace(/,/g, "")) - parseFloat($(".comision_tarjeta").val().replace(/,/g, "")) ;
    var cal2 = parseFloat($('#pago_efe').val().replace(/,/g, "")) - parseFloat(cal1);

    if(isNaN(cal2)){
        cal2 = 0;
    }

    $("#vuelto").text(formatNumber(cal2));
    //console.log('vuelto: '+cal2);
}

var opcion_pago_efectivo = function(monto){
    
    $("#pago_efe").val(formatNumber(monto));
    calculo_efectivo();
}

var listarPedidosDetalle = function(cod_atencion,id_pedido,id_venta){

    reset_default();
    $('.display-delivery').hide();
    $('.card_height').css('background','#fffde3');
    $('.card-body-right').css('display','block');
    $('.pedido-numero-icono').html('<i class="ti-arrow-circle-right"></i> ');
    $('.cont04').css('display','block');
    $('#list-pedidos-detalle').empty();
    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/listarPedidosDetalle',
        data: {
            cod_atencion: cod_atencion,
            id_pedido: id_pedido
        },
        success: function (data) {
// console.log(data)
            $('.pedido-numero').html(data.nro_pedido);

            var totPed = 0,
                total = 0;
            
            $('.pedido-cliente').text(data.nombre_cliente); 
            if(cod_atencion == 3){
                $('.display-delivery').show();                
                if(data.tipo_entrega == 1){
                    var tipo_entrega = '<span class="label label-primary">A DOMICILIO</span>';
                    $('.display-pedido-direccion').show();
                    $('.display-pedido-referencia').show();
                    $('.display-pedido-repartidor').show();
                    if(data.tipo_pago == 4){
                        $('.display-pedido-email').show();
                    } else {
                        $('.display-pedido-email').hide();
                    }
                }else{
                    var tipo_entrega = '<span class="label label-inverse">POR RECOGER</span>';
                    $('.display-pedido-email').hide();
                    $('.display-pedido-direccion').hide();
                    $('.display-pedido-referencia').hide();
                    $('.display-pedido-repartidor').hide();
                }
                $('.pedido-telefono').text(data.telefono_cliente);
                $('.pedido-email').text(data.email_cliente);
                $('.pedido-direccion').text(data.direccion_cliente);
                $('.pedido-referencia').text(data.referencia_cliente);
                $('.pedido-tipo-entrega').html(tipo_entrega);
                $('.pedido-repartidor').text(data.desc_repartidor);

                if(data.pedido_programado == 1){
                    var hora_entrega = moment(data.hora_entrega, 'HH:mm:ss');
                    $('.pedido-hora-entrega').text(moment(hora_entrega).format('hh:mm A'));
                    $('.pedido-total-amortizado').text(moneda+' '+formatNumber(data.amortizacion));
                } else {
                    $('.display-hora-entrega').hide();
                    $('.display-pedido-total-amortizado').hide();
                }

            } else {
                $('.display-delivery').hide();
            }
            if (data.Detalle.length != 0) {
                $.each(data.Detalle, function(i, item) {
                    totPed = (item.cant * item.precio);
                    $('#list-pedidos-detalle')
                    .append(
                        $('<div class="d-flex flex-row comment-row tr-left-3" onclick="subPedido(2,'+item.id_pedido+','+item.id_pres+',\''+item.precio+'\');"/>')
                        .append('<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">'
                        +'<h6 class="m-b-5">'+item.Producto.pro_nom+' <span class="label label-warning">'+item.Producto.pro_pre+'</span></h6>'
                        +'<p class="m-b-0 font-13">'+item.cant+' Unidad(es) en '+moneda+' '+formatNumber(item.precio)+' | Unidad</p></span>'
                        +'<span class="price">'+moneda+' '+formatNumber(totPed)+'</span></div>'));
                    total = totPed + total;    
                });
                $('.pedido-total').text(moneda+' '+formatNumber(total));
                $('#total_pagar').val(formatNumber(total)); 
                $('#total_pagar_').val(total);
                if(data.estado_pedido == 'a'){
                    if($('#codtipoped').val() == 3){
                        $('.display-opciones-pedido').show();
                        $('.opc-print-pedido').hide();
                        $('.opc-whatsapp-pedido').show();
                        $('.opc-ticket-pedido').show();
                        $('.opc-anular-pedido').show();
                        $('.opc-whatsapp-pedido').attr('onclick','enviar_whatsapp_pago(\''+data.nro_pedido+'\',\''+total+'\',\''+data.nombre_cliente+'\',\''+data.telefono_cliente+'\');');
                        $('.opc-ticket-pedido').attr('onclick','printPdf(\''+$("#url").val()+'venta/impresion_reparto_pedido/'+id_pedido+'\');');
                        $('.opc-facturar-pedido').html('<a class="dropdown-item" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="fas fa-plus"></i> Agregar productos</a>');
                        $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');
                        //$('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');">CONFIRMAR</a>');
                        $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="confirmar_pedido('+id_pedido+',\''+data.estado_pedido+'\');">CONFIRMAR</a>');
                        
                        if(data.tipo_entrega == 1){ //A DOMICILIO
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').show();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO;
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                            }
                        } else { //RECOGER
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').hide();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                                $('.opc-editar-pedido').hide();
                            }
                        }

                    } else {
                        $('.display-opciones-pedido').show();
                        $('.opc-print-pedido').hide();
                        $('.opc-whatsapp-pedido').hide();
                        $('.opc-facturar-pedido').hide();
                        $('.opc-editar-pedido').hide();
                        $('.opc-anular-pedido').show();
                        $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');
                        if($('#rol_usr').val() != 5){
                            $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="mdi mdi-receipt"></i> COBRAR</a>');
                        } else {
                            $('.btn-submit-nuevo-pedido').html('');
                        }
                    }                    
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-monto').show();
                } else if(data.estado_pedido == 'b'){
                    $('.display-opciones-pedido').show();
                    $('.opc-print-pedido').hide();
                    $('.opc-whatsapp-pedido').hide();
                    // $('.opc-facturar-pedido').hide();
                    if($('#codtipoped').val() == 3){

                        if(data.tipo_entrega == 1){ //A DOMICILIO
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').show();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO;
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                            }
                        } else { //RECOGER
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').hide();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                                $('.opc-editar-pedido').hide();
                            }
                        }
                        $('.opc-facturar-pedido').html('<a class="dropdown-item" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="fas fa-plus"></i> Agregar productos</a>');
                        
                        $('.opc-ticket-pedido').attr('onclick','printPdf(\''+$("#url").val()+'venta/impresion_reparto_pedido/'+id_pedido+'\');');

                        $('.opc-anular-pedido').show();
                        $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');
                    
                    } else {
                        $('.opc-editar-pedido').hide();
                        $('.opc-print-pedido').show();
                        $('.opc-print-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="impresion_ticket('+id_pedido+');"><i class="fas fa-print"></i> Ticket cliente</a>');
                        $('.opc-anular-pedido').show();
                        $('.opc-anular-pedido').attr('onclick','anular_venta('+id_pedido+',\''+data.nro_pedido+'\','+id_venta+');');
                    }

                    if(cod_atencion == 2){
                        $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="pedidoAccion(3,\'b\','+data.id_pedido+');">ENTREGADO</a>');
                    }else{
                        if($('#rol_usr').val() != 5){
                            // console.log(data.estado_pedido)
                            if (data.estado_pedido!='b') {
                                $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" data-toggle="tooltip" data-placement="top" data-original-title="Confirmar" onclick="confirmar_pedido('+id_pedido+',\''+data.estado_pedido+'\');">CONFIRMAR</a> ');
                            }else{
                                $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'?cobra_directo=si" data-toggle="tooltip" data-placement="top" data-original-title="Cobrar">COBRAR</a>');
                            }
                        } else {
                            $('.btn-submit-nuevo-pedido').html('');
                        }
                    }
                    // $('.opc-facturar-pedido').html('<a class="dropdown-item" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="fas fa-plus"></i> Agregar productos</a>');
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-monto').hide();

                } else if(data.estado_pedido == 'c'){
                    $('.display-opciones-pedido').show();
                    $('.opc-whatsapp-pedido').hide();
                    $('.opc-editar-pedido').show();
                    $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_venta_pago('+id_venta+');"><i class="fas fa-edit"></i> Editar venta</a>');
                        $('.display-entrega-programada').hide();
                        $('.display-pedido-repartidor-edit').hide();
                        $('.display-paga-con').hide();
                        $('.display-comision-delivery').hide();
                    $('.opc-anular-pedido').show();
                    $('.opc-anular-pedido').attr('onclick','anular_venta('+id_pedido+',\''+data.nro_pedido+'\','+id_venta+');');
                    $('.opc-print-pedido').show();
                    $('.opc-print-pedido').html('<a class="dropdown-item" href="'+$("#url").val()+'venta/impresion_reparto/'+id_venta+'" target="_blank"><i class="fas fa-print"></i> Ticket reparto</a>');
                    $('.opc-facturar-pedido').html('');
                    $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="pedidoAccion(2,\'c\','+data.id_pedido+');">ENTREGADO</a>');
                    //$('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="mdi mdi-receipt"></i> FACTURAR</a>');
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-pago').hide();
                    $('.display-pedido-monto').hide();
                    $('.display-pedido-total-amortizado').hide();
                } else if(data.estado_pedido == 'd'){
                    $('.display-opciones-pedido').hide();
                    $('.btn-submit-nuevo-pedido').html('');
                    $('.card-footer-right').css('display','none');
                    $('.display-pedido-pago').hide();
                    $('.display-pedido-monto').hide();
                    $('.display-pedido-total-amortizado').hide();
                }
            } else {
                $('.pedido-total').text(moneda+' 0.00');
                $('.card-footer-right').css('display','none');
                $('.display-opciones-pedido').hide();
                $('.totalPagar').html('');
                $('.btn-submit-nuevo-pedido').html('');
                alert("22")
                alert(id_pedido)
                $('#list-pedidos-detalle').html('<div class="justify-center m-t-40" style="height: 100%;"><div class="text-center"><h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2><h4 style="color: #d3d3d3;"><a class="btn btn-success" href="'+$("#url").val()+'venta/orden/'+id_pedido+'" class="link">Agregue productos</a></h4><h6 style="color: #d3d3d3;">No se encontraron productos</h6></div></div>');    
            }
        }
    });
}

var pedidoAccion = function(cod_accion,estado_pedido,id_pedido){
    /* cod_accion
        1 = enviar delivery, 2 = entregado delivery, 3 = entregado mostrador
    */
    if(cod_accion == 1){
        var accion = 'PREPARADO';
    }else if(cod_accion == 2 || cod_accion == 3){
        var accion = 'ENTREGADO';
    }
    var html_confirm = '<div><br>\
        <div style="width: 100% !important; float: none !important;">\
            <table class="table m-b-0">\
                <tr><td class="text-left">Pedido: </td><td class="text-right">'+$('.pedido-numero').text()+'</td></tr>\
            </table>\
        </div><br>\
        Ingrese código de vaucher</div>\
        <form><input class="form-control text-center w-100" type="text" id="codigo_vaucher" autocomplete="off"/></form><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'venta/pedidoAccion',
                    type: 'POST',
                    data: {
                        cod_accion : cod_accion,
                        id_pedido : id_pedido,
                        codigo_operacion : $("#codigo_vaucher").val()
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    Swal.fire({
                        title: 'Proceso Terminado',
                        text: 'El pedido ha sido '+accion,
                        icon: 'success',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                    reset_default();
                    $('.cont01').css('display','flex');
                    if(cod_accion == 1 || cod_accion == 2){
                        if(estado_pedido == 'b'){
                            delivery_list_b();
                        }else if(estado_pedido == 'c'){
                            delivery_list_c();
                        }
                    } else if(cod_accion == 3){
                        mostrador();
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
}

var registrarMesa = function(id_mesa,nro_mesa,salon){
    var html_confirm = '<div>Se procederá aperturar la siguiente mesa:</div><br>\
    <table class="table m-b-0">\
    <tr><td class="text-left">Salon: </td><td class="text-right">'+salon+'</td></tr>\
    <tr><td class="text-left">Mesa: </td><td class="text-right">'+nro_mesa+'</td></tr>\
    </table>\
    <label>Nro personas</label>\
    <input class="form-control numero-personas text-center" type="text" value="1" id="nro_personas"/><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'venta/pedido_create/pc1',
                    type: 'POST',
                    data: {
                        id_mesa: id_mesa,
                        nomb_cliente: 'Mesa '+nro_mesa,
                        nro_personas: $("#nro_personas").val()
                    },
                    dataType: 'json',
                    success: function (data) {
                        if(data['fil'] == 1){
                            window.open($("#url").val()+'venta/orden/'+data['id_pedido'],'_self');
                        }else{
                            window.open($("#url").val()+'venta','_self');
                        }
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
    $('.numero-personas').TouchSpin({
        buttondown_class: "btn btn-secondary",
        buttonup_class: "btn btn-secondary",
        min: 1,
        mousewheel: false
    });
}

var orden = function(id_pedido){
    window.open($("#url").val()+'venta/orden/'+id_pedido,'_self');
}

var list_categorias_menu = function(){
    $('.categoriamenu').css('display','block');
    $('#categoriamenu').css('display','none');
    $('#modal-lista-menu').modal('show');
    $('.list_categorias_menu').empty();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/menu_categoria_list",
        dataType: "json",
        success: function(item){
            if(item.data.length > 0){
                $.each(item.data, function(i, item) {
                    var categoria_nombre = (item.descripcion).substr(0,1).toUpperCase()+(item.descripcion).substr(1).toLowerCase();
                    $('.list_categorias_menu')
                        .append(
                        $('<li class="nav-item m-t-10"/>')
                            .html('<a class="nav-link bg-header" data-toggle="tab" href="#categoriamenu" onclick="list_platos_menu('+item.id_catg+');" role="tab">'
                                +'<span class="hidden-sm-up">'+categoria_nombre+'</span>'
                                +'<span class="hidden-xs-down font-14">'+categoria_nombre+'</span> </a>')
                        )
                });
            }else{
                $('.list_categorias_menu').html("");
            }
        }
    });
}

var list_platos_menu = function(id_catg){

    $('.categoriamenu').css('display','none');
    $('#categoriamenu').css('display','block');
    
    function filterGlobal () {
    $('#list_platos_menu').DataTable().search( 
    $('#search_filter_menu').val()
    ).draw();
    }
    
    var count = 0;
    var table = $('#list_platos_menu')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": false,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/menu_plato_list",
            "data": {
                id_catg: id_catg
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                var pro_nom = (data.pro_nom).substr(0,1).toUpperCase()+(data.pro_nom).substr(1).toLowerCase();
                var pro_pre = (data.pro_pre).substr(0,1).toUpperCase()+(data.pro_pre).substr(1).toLowerCase();
        return pro_nom+' | '+pro_pre+' | '+$('#moneda').val()+' '+data.pro_cos;
            }},
            {"data": null,
                "render": function(data, type, row){
                var checked = (data.est_c == 'a') ? 'checked' : '';
                return '<div class="switch text-right" onclick="estado_plato_menu('+data.id_catg+','+data.id_pres+',\''+data.est_c+'\');"><label class="m-b-0"><input type="checkbox" '+checked+'><span class="lever switch-col-light-green"></span></label></div>';
            }}
        ]
    });
    
    $('input.search_filter_menu').on( 'keyup click', function () {
      filterGlobal();
  });
}

var estado_plato_menu = function(id_catg,id_pres,estado){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/menu_plato_estado",
        dataType: "json",
        data: {
            id_pres : id_pres,
            estado : estado
        },
        success: function(request){
            list_platos_menu(id_catg);
        }
    });
}

var nuevoPedidoMesa = function(id_mesa,mesa,salon){
    $('#codsalonorigen').val('0');
    $('#codmesaorigen').val('0');
    $('.id-mesa').val(id_mesa);
    
    //////////////////////////////////////
    reset_default();
    $('.display-mozo').css('display','block');
    $("#id_mozo").removeAttr('disabled');
    $('#id_mozo').selectpicker('refresh');
    $('#id_mozo').selectpicker('val', ''+id_mozo_+'');
    $("#nomb_cliente").removeAttr('disabled');
    $('.pedido-mozo').hide();
    $('.display-personas').css('display','block');
    $('.numero-personas').TouchSpin({
        buttondown_class: "btn btn-link text-success",
        buttonup_class: "btn btn-link text-success",
        min: 1,
        mousewheel: false
    });
    ///////////////////////////////////////////   
    // $('.card_height').css('background','#fffde3');
    $('.card_height').css('background','#ffffff');
    $('.card-body-right').css('display','block');
    $('.cont02').css('display','block');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html(salon+' - Mesa: '+mesa);
    $('.card-footer-right').css('display','block');
    $('.display-opciones-pedido').hide();
    /////////////////////////////////////////////
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    $("#nomb_cliente").val('Mesa: '+mesa);
    $('.btn-submit-nuevo-pedido').html('<button type="submit" class="btn btn-orange btn-submit-nuevo-pedido">Continuar <i class="fas fa-arrow-right"></i></button>');
}

var tab01 = function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc1');
    $('.display-estado-mesa').css('display','block');
    $('input[name^="codtipoped"]').val(1);
    /////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','block');
    $('.cont01-2').css('display','none');
    $('.nomPed').html('una mesa');
    $('.dim').removeClass('active');
    $('#codpestdelivery').val(0);
}

var tab02 =  function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc2');
    $('.display-estado-mesa').css('display','none');
    $('input[name^="codtipoped"]').val(2);
    /////////////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','none');
    $('.cont01-2').css('display','block');
    $('.nomPed').html('un pedido');
    $('#codpestdelivery').val(0);
}

var tab03 = function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc3');
    $('.display-estado-mesa').css('display','none');
    $('input[name^="codtipoped"]').val(3);
    ///////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','none');
    $('.cont01-2').css('display','block');
    $('.nomPed').html('un pedido');
    $('#codpestdelivery').val(1);
    //$('#cliente_id').val('');
}

$('.tab01,.list-salones').click( function() {
    tab01();
});

$('.tab02').click( function() {
    tab02();
});

$('.tab03').click( function() {
    tab03();
});

$('.btn-nuevo-pedido').click( function() {
    reset_default();
    $('.card_height').css('background','#fffde3');
    //$('.card_height').css('background','#FFFFF0');
    $('.card-body-right').css('display','block');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html('Nuevo pedido:');
    $('.cont02').css('display','block');
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    if($('#codtipoped').val() == 2){
        $('.display-nombre').css('display','block');
        $("#nomb_cliente").removeAttr('disabled');
        $("#nomb_cliente").val('PUBLICO GENERAL');
        $("#nomb_cliente").select()
        $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
        $('#id_tdoc').selectpicker('val', '1');
        $('#id_repartidor').selectpicker('refresh');

        $('#num_cliente').attr('maxlength', 8)
        $('#num_cliente').val('00000000')

    } else if($('#codtipoped').val() == 3){
        //$('#cliente_id').val('');
        $('.display-pedido-programado').css('display','block');
        $('#tipo_entrega_1').prop('checked', true);
        $('#tipo_entrega_2').prop('checked', false);
        $('.display-tipo-entrega').css('display','block');
        $('.btn-tipo-entrega-1').addClass('active');
        $('.btn-tipo-entrega-2').removeClass('active');
        $('.display-telefono-cliente').css('display','block');
        $("#telefono_cliente").removeAttr('disabled');
        $("#telefono_cliente").val('0000');
        $('.display-nombre').css('display','block');
        $("#nomb_cliente").removeAttr('disabled');
        $("#nomb_cliente").val('GENERAL');
        $('.display-direccion-cliente').css('display','block');
        $("#direccion_cliente").removeAttr('disabled');
        $("#direccion_cliente").val('-');
        $("#referencia_cliente").val('-');
        $('.display-referencia-cliente').css('display','block');
        $("#referencia_cliente").removeAttr('disabled');
        $('.display-repartidor').css('display','block');
        $("#id_repartidor").removeAttr('disabled');

        $('#id_tdoc').selectpicker('val', '1');
        $('#id_repartidor').selectpicker('refresh');

        $('#num_cliente').attr('maxlength', 8)
        $('#num_cliente').val('00000000')

        $('#id_repartidor').selectpicker('val', ''+id_repartidor_+'');
        $('#id_repartidor').selectpicker('refresh');

        $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
        //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-secondary" onclick="nuevo_cliente();" type="button"><i class="fa fa-user-plus"></i></button>');
        setTimeout(() => {
            $("#telefono_cliente").focus();
        }, 500);

    }
    $('.card-footer-right').css('display','block');
    $('.btn-submit-nuevo-pedido').html('<button type="submit" class="btn btn-orange btn-submit-nuevo-pedido">Continuar <i class="fas fa-arrow-right"></i></button>');
    $('.display-opciones-pedido').hide();
});

$('.btn-cancelar-pedido').click( function(){
    if($('#codtipoped').val() == 1){
        tab01();
    } else if($('#codtipoped').val() == 2){
        tab02();
    } else if($('#codtipoped').val() == 3){
        tab03();
    }
    /*
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    */
});

$('.btn-tipo-entrega-1').on('click', function(event){
    $('.display-nombre').css('display','block');
    $("#nomb_cliente").prop('disabled', false);
    $('.display-direccion-cliente').css('display','block');
    $("#direccion_cliente").prop('disabled', false);
    $('.display-referencia-cliente').css('display','block');
    $("#referencia_cliente").prop('disabled', false);
    $('.display-repartidor').css('display','block');
    $("#id_repartidor").prop('disabled', false);
    $('#id_repartidor').selectpicker('refresh');
    $('#id_repartidor').selectpicker('val', '');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
});

$('.btn-tipo-entrega-2').on('click', function(event){
    $('.display-nombre').css('display','block');
    $("#nomb_cliente").prop('disabled', false);
    $('.display-direccion-cliente').css('display','none');
    $("#direccion_cliente").prop('disabled', true);
    $('.display-referencia-cliente').css('display','none');
    $("#referencia_cliente").prop('disabled', true);
    $('.display-repartidor').css('display','none');
    $("#id_repartidor").prop('disabled', true);
    $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
});

/* INICIO - OPCION DE MESAS */
/* 1.- OPCION CAMBIAR MESA  */
/* Combo mesa origen */
var comboMesaOrigenOpc01 = function(cod_salon_origen_opc01){
    $('#cod_mesa_origen_opc01').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaOri",
        data: {
            cod_salon_origen: cod_salon_origen_opc01
        },
        success: function (response) {
            $('#cod_mesa_origen_opc01').html(response);
            $('#cod_mesa_origen_opc01').selectpicker();
            $('#cod_mesa_origen_opc01').selectpicker('refresh');
            $('#cod_mesa_origen_opc01').val($('#codmesaorigen').val()).selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_origen_opc01').html('There was an error!');
        }
    });
}

/* Combo mesa destino */
var comboMesaDestinoOpc01 = function(cod_salon_destino_opc01){
    $('#cod_mesa_destino_opc01').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaDes",
        data: {
            cod_salon_destino: cod_salon_destino_opc01,
            estado: 'a'
        },
        success: function (response) {
            $('#cod_mesa_destino_opc01').html(response);
            $('#cod_mesa_destino_opc01').selectpicker();
            $('#cod_mesa_destino_opc01').selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_destino_opc01').html('There was an error!');
        }
    });
}

/* Combo salon origen */
$('#cod_salon_origen_opc01').change( function() {
    var cod_salon_origen_opc01 = $('#cod_salon_origen_opc01').val();
    comboMesaOrigenOpc01(cod_salon_origen_opc01);
    $('#form-cambiar-mesa').formValidation('revalidateField', 'cod_mesa_origen_opc01');
});

/* Combo salon destino */
$('#cod_salon_destino_opc01').change( function() {
    var cod_salon_destino_opc01 = $('#cod_salon_destino_opc01').val();
    comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

/* Boton cambiar mesa */
$('.opc-cambiar-mesa').click( function() {
    $('#cod_salon_origen_opc01').val($('#codsalonorigen').val()).selectpicker('refresh');
    var cod_salon_destino_opc01 = $('#cod_salon_destino_opc01').val();
    comboMesaOrigenOpc01($('#codsalonorigen').val());
    comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

$('#modal-cambiar-mesa').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-cambiar-mesa').formValidation('resetForm', true);
    $('#cod_salon_origen_opc01').val('').selectpicker('refresh');
    $('#cod_salon_destino_opc01').val('').selectpicker('refresh');
});
/* OPCION CAMBIAR MESA  */

/* 2.- OPCION MOVER PEDIDOS  */
/* Combo mesa origen */
var comboMesaOrigenOpc02 = function(cod_salon_origen_opc02){
    $('#cod_mesa_origen_opc02').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaOri",
        data: {
            cod_salon_origen: cod_salon_origen_opc02
        },
        success: function (response) {
            $('#cod_mesa_origen_opc02').html(response);
            $('#cod_mesa_origen_opc02').selectpicker();
            $('#cod_mesa_origen_opc02').selectpicker('refresh');
            $('#cod_mesa_origen_opc02').val($('#codmesaorigen').val()).selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_origen_opc02').html('There was an error!');
        }
    });
}

/* Combo mesa destino */
var comboMesaDestinoOpc02 = function(cod_salon_destino_opc02){
    $('#cod_mesa_destino_opc02').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaDes",
        data: {
            cod_salon_destino: cod_salon_destino_opc02,
            estado: 'i'
        },
        success: function (response) {
            $('#cod_mesa_destino_opc02').html(response);
            $('#cod_mesa_destino_opc02').selectpicker();
            $('#cod_mesa_destino_opc02').selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_destino_opc02').html('There was an error!');
        }
    });
}

/* Combo salon origen */
$('#cod_salon_origen_opc02').change( function() {
    var cod_salon_origen_opc02 = $('#cod_salon_origen_opc02').val();
    comboMesaOrigenOpc02(cod_salon_origen_opc02);
    $('#form-mover-pedidos').formValidation('revalidateField', 'cod_mesa_origen_opc02');
});

/* Combo salon destino */
$('#cod_salon_destino_opc02').change( function() {
    var cod_salon_destino_opc02 = $('#cod_salon_destino_opc02').val();
    comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

/* Boton cambiar mesa */
$('.opc-mover-pedidos').click( function() {
    $('#cod_salon_origen_opc02').val($('#codsalonorigen').val()).selectpicker('refresh');
    var cod_salon_destino_opc02 = $('#cod_salon_destino_opc02').val();
    comboMesaOrigenOpc02($('#codsalonorigen').val());
    comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

$('#modal-mover-pedidos').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-mover-pedidos').formValidation('resetForm', true);
    $('#cod_salon_origen_opc02').val('').selectpicker('refresh');
    $('#cod_salon_destino_opc02').val('').selectpicker('refresh');
});
/* OPCION MOVER PEDIDOS  */

/* FIN OPCION DE MESAS */

/************  */

var reset_default = function(){
    $('.cont01').css('display','none');
    $('.cont02').css('display','none');
    $('.cont03').css('display','none');
    $('.cont04').css('display','none');
    $('.card-body-right').css('display','none');
    $('.card-footer-right').css('display','none');
    $('.card_height').css('background','#666');
    $('.totalPagar').html('');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html('Detalle:');
    // NONE DISPLAY
    $('.display-pedido-programado').css('display','none');
    $('.pedido_programado').prop('checked', false);
    $('.pedido_programado').val('0');
    $('.display-tipo-entrega').css('display','none');
    $('.display-hora-entrega').css('display','none');
    $('.display-pedido-total-amortizado').css('display','none');
    $('.display-busqueda-cliente').css('display','none');
    $('.display-nombre').css('display','none');
    $('.display-telefono-cliente').css('display','none');
    $('.display-direccion-cliente').css('display','none');
    $('.display-referencia-cliente').css('display','none');
    $('.display-repartidor').css('display','none');
    $('.display-personas').css('display','none');
    $('.display-mozo').css('display','none');
    //DISABLED INPUT
    $("#hora_entrega").attr('disabled','true');
    $("#nomb_cliente").attr('disabled','true');
    $("#telefono_cliente").attr('disabled','true');
    $("#direccion_cliente").attr('disabled','true');
    $("#referencia_cliente").attr('disabled','true');
    $("#id_repartidor").attr('disabled','true');
    $("#id_mozo").attr('disabled','true');
    $('.btn-submit-dividir-cuenta').html('');
    $('.btn-submit-cobrar').html('');
}

$('.mostrador01').click( function() {
    mostrador_list_a();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.mostrador02').click( function() {
    mostrador_list_b();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.mostrador03').click( function() {
    mostrador_list_c();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.delivery01').click( function() {
    delivery_list_a();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(1);
});

$('.delivery02').click( function() {
    delivery_list_b();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);
});

$('.delivery03').click( function() {
    delivery_list_c();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);
});

$('.delivery04').click( function() {
    delivery_list_d();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);
});

/****   *///

/* Link de pago whatsapp */
var enviar_whatsapp_pago = function(nro_pedido,total_pedido,cliente,telefono){
    var html_confirm = '<div>Enviar mensaje:</div>\
    <div class="font-18 font-bold">Pedido N° '+nro_pedido+'</div><br>\
    <div><form><textarea id="textarea" class="form-control" rows="8">Hola '+cliente+': Ya aceptamos tu solicitud de tu pedido por un monto de '+$('#moneda').val()+' '+formatNumber(total_pedido)+'. Gracias por confiar en nosotros</textarea><input class="form-control text-center w-100" type="text" id="num_cliente" value="51'+telefono+'" autocomplete="off"/></div><div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    window.setTimeout(function(){
        var obj = $("#num_cliente"),
        val = obj.val();
        obj.focus().val("").val(val);
        obj.scrollTop(obj[0].scrollHeight);
    }, 300);

    Swal.fire({
        title: '',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            if ($('#api_wsp').val()==1) {
                 $.ajax({
                    url: $('#url').val()+'whatsapp/send_wsp_txt',
                    type: 'POST',
                    data: {
                        num_cliente : $('#num_cliente').val(),
                        mensaje : $('#textarea').val()
                    },
                    dataType: 'json'
                 })
                 .done(function(response){
                    if(response.status == true){
                        Swal.fire({
                            title: 'Proceso Terminado',
                            html: 'Whatsapp enviado correctamente <br><br> <strong>Respuesta server: </strong>Mensaje enviado con éxito',
                            icon: 'success',
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "OK"
                        });
                    }else{
                        Swal.fire({
                            title: 'Proceso No Culminado',
                            html: ''+response.msg+'<br>'+response.errors ? response.errors : ''+'',
                            icon: 'error',
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "OK"
                        });
                    }
                 })
                 .fail(function(error){
                    // console.log(error)
                    console.log(error.responseText)
                    Swal.fire('Oops...', 'Error: '+error.responseText.msg+'', 'error');
                 });
            }else{
                window.open('https://api.whatsapp.com/send?phone=51'+telefono+'&text='+$('#textarea').val() ,'_blank');
            }
        }            
    });
}

var anular_pedido = function(id_pedido){
    var html_confirm = '<div>Se procederá a anular este pedido</div><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'venta/anular_pedido',
                    type: 'POST',
                    data: {
                        id_pedido : id_pedido,
                        tipo_pedido : $("#codtipoped").val()
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    window.open($("#url").val()+'venta','_self');
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
}

var anular_venta = function(id_pedido,nro_pedido,id_venta){
    var html_confirm = '<div>Se procederá a anular el siguiente pedido:</div>\
    <div class="font-18 font-bold">Pedido N° '+nro_pedido+'</div><br>\
    Ingrese código de seguridad</div><br>\
    <form><input class="form-control text-center w-50" type="password" id="codigo_anular_venta_" autocomplete="off"/></form><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                if($('#codigo_anular_venta').val() == $('#codigo_anular_venta_').val()){
                    $.ajax({
                        url: $('#url').val()+'venta/anular_venta',
                        type: 'POST',
                        data: {
                            id_venta : id_venta,
                            id_pedido : id_pedido
                        },
                        dataType: 'json'
                    })
                    .done(function(response){
                        window.open($("#url").val()+'venta','_self');
                    })
                    .fail(function(){
                        Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                    });
                } else {
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'El código ingresado es incorrecto',
                        icon: 'error',
                        confirmButtonColor: '#34d16e',
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }            
    });
}

var editar_pedido = function(id_pedido){
    $('#modal-editar-pedido').modal('show');
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_pedido: id_pedido
      },
      url: $('#url').val()+'venta/pedido_edit',
        success: function (item){
            $.each(item.data, function(i, campo) {
                // console.log("campo",campo)
                // console.log("editar_pedido",campo.paga_con)
                $('#id_pedido').val(id_pedido);
                $('#id_repartidor_edit').selectpicker('val', campo.id_repartidor);
                $('#hora_entrega_edit').selectpicker('val', campo.hora_entrega);
                $('#amortizacion').val(campo.amortizacion);
                $('#id_tipo_pago').selectpicker('val', campo.tipo_pago);

                if (campo.paga_con==='0.00') {
                    setTimeout(function(){
                      $('#paga_con').val(formatNumber($('#total_pagar_').val()));
                    }, 500);
                }else{
                    $('#paga_con').val(campo.paga_con);
                }

                $('#comision_delivery').val(campo.comision_delivery);
                if(campo.tipo_pago == 1){
                    $('.display-paga-con').show();
                } else {
                    $('.display-paga-con').hide();
                }
            });
        }
    });
}

$("#id_tipo_pago").change(function() {
    if(this.value == 1){
        $('.display-paga-con').show();
    } else {
        $('.display-paga-con').hide();
    }
});

var editar_venta_pago = function(id_venta){
    $('#modal-editar-venta-pago').modal('show');
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_venta: id_venta
      },
      url: $('#url').val()+'venta/venta_edit',
        success: function (item){
            $.each(item.data, function(i, campo) {
                $('#id_pedido').val(campo.id_pedido);
                $('#id_venta').val(campo.id_venta);
                $('#id_venta_tipopago').val(campo.id_tipo_pago);
                $('#id_tipo_pago_v').selectpicker('val', campo.id_tipo_pago);
            });
        }
    });
}

 confirmar_pedido = function(id_pedido,estado_pedido){
    var html_confirm ='<div>Enviar los productos para su preparación, a su área de producción correspondiente</div><br>\
    <div style="width: 100% !important; float: none !important;">\
        <table class="table m-b-0">\
            <tr><td class="text-left">Pedido: </td><td class="text-right">'+$('.pedido-numero').text()+'</td></tr>\
            <tr><td class="text-left">Cliente: </td><td class="text-right">'+$('.pedido-cliente').text()+'</td></tr>\
        </table>\
    </div><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                impresion_comanda(id_pedido,estado_pedido);
                printPdf($("#url").val()+'venta/impresion_reparto_pedido/'+id_pedido);
                //window.open($("#url").val()+'venta','_self');
                delivery_list_a();
                reset_default();
                $('.cont01').css('display','flex');
                swal.close();
            });
        }       
    });
}

var alert_pedidos_programados = function(){
    $.ajax({
      type: "post",
      dataType: "json",
      url: $('#url').val()+'venta/alert_pedidos_programados',
        success: function (data){
            var fecha1 = moment($('#hora').val(), 'HH:mm:ss');
            var fecha2 = moment(data.hora_entrega, 'HH:mm:ss');
            var duration = moment.duration(fecha2 - fecha1).humanize();
            var minutos = fecha2.diff(fecha1, 'minutes');
            if(minutos < 30){
                html = '';
                var html_confirm = '<div class="font-16">Hay un pedido para las <strong>'+moment(fecha2).format('hh:mm A')+'</strong> esperando ser enviado a <strong>PREPARACIÓN</strong></div>\
                <br><div style="width: 100% !important; float: none !important;">\
                    <table class="table m-b-0">\
                    <tr><td class="text-left">Pedido: </td><td class="text-right">'+data.nro_pedido+'</td></tr>\
                    <tr><td class="text-left">Cliente: </td><td class="text-right">'+data.nombre_cliente+'</td></tr>\
                    </table>\
                </div><br>\
                <div><span class="text-success" style="font-size: 17px;">¿Continuar ahora?</span></div>';
                Swal.fire({
                    title: '',
                    html: html_confirm,
                    icon: 'info',
                    position: 'top-end',
                    showCancelButton: true,
                    confirmButtonColor: '#34d16e',
                    confirmButtonText: 'Si, Adelante!',
                    cancelButtonText: "No!",
                    showLoaderOnConfirm: true,
                    preConfirm: function() {
                        return new Promise(function(resolve) {
                            $('#codtipoped').val(3);
                            listarPedidosDetalle(3,data.id_pedido,0);
                            activaTab('tabp-3');
                            activaTab('delivery01');
                            delivery_list_a();
                            $('.display-estado-mesa').css('display','none');
                            $('.cont01-1').css('display','none');
                            $('.cont01-2').css('display','block');
                            Swal.close();
                        });
                    }             
                });
                var sound = new buzz.sound($('#url').val()+"public/sound/alert02", {
                    formats: [ "ogg", "mp3", "aac" ]
                });
                sound.play();
            }
            //alert(duration);
        }
    });
}

var validarApertura = function(){
    if($('#cod_ape').val() == 0 && $('#rol_usr').val() != 1){
        var html_confirm = '<div>Para poder realizar esta operación es necesario Aperturar Caja</div>\
            <br>\
            <div><span class="text-success" style="font-size: 18px;">¿Está Usted de Acuerdo?</span></div><br>\
            <a href="'+$("#url").val()+'caja/apercie" class="btn btn-success">Si, Adelante!</a>';

        Swal.fire({
            title: 'Advertencia',
            html: html_confirm,
            icon: 'warning',
            allowOutsideClick: false,
            allowEscapeKey : false,
            showCancelButton: false,
            showConfirmButton: false,
            closeOnConfirm: false,
            closeOnCancel: false
        });
    }
}

$('.pedido_programado').on('click', function(event){
    if( $(this).is(':checked') ) {
        $('#pedido_programado').val('1');
        $('.display-hora-entrega').css('display','block');
        $("#hora_entrega").removeAttr('disabled');
        $('#hora_entrega').selectpicker('refresh');
        $('#hora_entrega').selectpicker('val', '');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'hora_entrega');
    } else {
        $('#pedido_programado').val('0');
        $("#hora_entrega").prop('disabled', true);
        $('.display-hora-entrega').css('display','none');
    }
});

/*
var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = window.location.search.substring(1),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
};
*/

function activaTab(tab){
    $('.nav-tabs a[href="#' + tab + '"]').tab('show');
};

var impPreCuenta = function(id_pedido,id_mesa,estado,wiew){

    
    $.ajax({
        url: $("#url").val()+'venta/pedido_estado_update',
        type: "post",
        dataType: "json",
        data: {
            id_mesa: id_mesa,
            estado: estado
        },
        success: function (r) {
            return true;
        }
    }).done(function(){
        if(wiew){
            printPdf($("#url").val()+'venta/impresion_precuenta/'+id_pedido,true);
        }else{
            window.open($("#url").val()+'venta/impresion_precuenta/'+id_pedido,'_blank');            
        }
    }); 
}


var printPdf = function(url,condicional) {

    var userAgent = navigator.userAgent || navigator.vendor || window.opera;
    
    window.open(url, '_blank');
    
    
    // if ((/android/i.test(userAgent)) || (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) ) {
    //     // if(condicional){
    //         var Urlpdf = url;
    //     // }else{
    //     //     var Urlpdf = $("#url").val()+'informe/venta_all_imp/'+url;   
    //     // }
    //     window.open(Urlpdf, '_blank');
    // }else{
    //     if(condicional){
    //         var Urlpdf = url;
    //     }else{
    //          var Urlpdf = $("#url").val()+'informe/venta_all_imp/'+url;   
    //     }
      
    //     var iframe = document.createElement('iframe');
    //     iframe.className='pdfIframe'
    //     document.body.appendChild(iframe);
    //     iframe.style.display = 'none';
    //     iframe.onload = function () {
    //         setTimeout(function () {
    //             iframe.focus();
    //             iframe.contentWindow.print();
    //             URL.revokeObjectURL(Urlpdf)
    //         }, 0);
    //     };
    //     iframe.src = Urlpdf;
    //     URL.revokeObjectURL(Urlpdf)
    // }
};

var nuevo_cliente_vista = function(){
    if($('#codcomision').val() == 1){
        $("#td_dni").attr('checked', false);
        $("#td_ruc").attr('checked', false);
        $(".block01").css("display","none");
        $(".block02").css("display","none");
        $(".block03").css("display","none");
        $(".block04").css("display","none");
        $(".block05").css("display","none");
        $(".block06").css("display","none");
        $(".block07").css("display","none");
        $(".block08").css("display","none");
    } 

    console.log($('#cliente_tipo').val());
    
    
    if($('#cliente_tipo').val() != ''){
        if($('#cliente_tipo').val() == 1){
            $('#tipo_cliente').val(1);
            $(".block01").css("display","block");
            $(".block02").css("display","none");
            $(".block03").css("display","block");
            $(".block04").css("display","none");
            $(".block05").css("display","block");
            $(".block06").css("display","block");
            $(".block07").css("display","none");
            $(".dni").prop('disabled', false);
            $(".ruc").prop('disabled', true);
            $('#form-cliente').formValidation('resetForm', true);
            $('#dni').val($('#buscar_cliente').val().replace(/[^0-9]/g, ''))
            setTimeout(() => {
                $("#dni").select()
            }, 200);
            $("#seleccionar").select()
            $('#modal-cliente').modal('show');
        } else if($('#cliente_tipo').val() == 2){

            $('#tipo_cliente').val(2);
            $(".block01").css("display","none");
            $(".block02").css("display","block");
            $(".block03").css("display","none");
            $(".block04").css("display","none");
            $(".block05").css("display","none");
            $(".block06").css("display","none");
            $(".block07").css("display","block");
            $(".dni").prop('disabled', true);
            $(".ruc").prop('disabled', false);
            $('#form-cliente').formValidation('resetForm', true);
            $('#ruc').val($('#buscar_cliente').val())
            $('#modal-cliente').modal('show');
        } else if($('#cliente_tipo').val() == 3){
            $('#tipo_cliente').val(1);
            $(".block01").css("display","block");
            $(".block02").css("display","none");
            $(".block03").css("display","block");
            $(".block04").css("display","block");
            $(".block05").css("display","block");
            $(".block06").css("display","block");
            $(".block07").css("display","none");
            $(".dni").prop('disabled', false);
            $(".ruc").prop('disabled', true);
            $('#form-cliente').formValidation('resetForm', true);
            $('#dni').val($('#buscar_cliente').val().replace(/[^0-9]/g, ''))
            setTimeout(() => {
                $("#dni").select()
            }, 200);
            $('#modal-cliente').modal('show');
        }else {
            //$('#modal-cliente').modal('show');
        }
    }
}

/* Nuevo Cliente */
var nuevoClienteVista = function(){
    console.log("adasd");
    
    nuevo_cliente_vista();
}



$('#id_tdoc').change(function(){
    if ($('#id_tdoc').val()==1) {
        $('#num_cliente').attr('maxlength', 8)
        $('#num_cliente').val('00000000')
    }
    if ($('#id_tdoc').val()==2) {
        $('#num_cliente').attr('maxlength', 11)
        $('#num_cliente').val('')
    }
});